/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.util;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.hisun.phone.core.voice.Build;
import com.hisun.phone.core.voice.util.Log4Util;

public class UserAgentUtils {
    public static String getUser_Agent(Context context) {
        String ua = "Android;" + UserAgentUtils.getOSVersion() + ";" + "3.6.4" + ";" + Build.LIBVERSION.FULL_VERSION + ";" + UserAgentUtils.getVendor() + "-" + UserAgentUtils.getDevice() + ";";
        ua = ua + UserAgentUtils.getDevicNO(context) + ";" + System.currentTimeMillis() + ";";
        Log4Util.d("User_Agent : " + ua);
        return ua;
    }

    public static String getDevicNO(Context context) {
        if (!TextUtils.isEmpty((CharSequence)UserAgentUtils.getDeviceId(context))) {
            return UserAgentUtils.getDeviceId(context);
        }
        if (!TextUtils.isEmpty((CharSequence)UserAgentUtils.getMacAddress(context))) {
            return UserAgentUtils.getMacAddress(context);
        }
        return "";
    }

    public static String getDeviceId(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return telephonyManager.getDeviceId();
        }
        return null;
    }

    public static String getMacAddress(Context context) {
        WifiInfo wifiInf;
        WifiManager wifiMan = (WifiManager)context.getSystemService("wifi");
        if (wifiMan != null && (wifiInf = wifiMan.getConnectionInfo()) != null && wifiInf.getMacAddress() != null) {
            return wifiInf.getMacAddress();
        }
        return null;
    }

    public static String getDevice() {
        return Build.MODEL;
    }

    public static String getVendor() {
        return Build.BRAND;
    }

    public static int getAndroidSDKVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static String getOSVersion() {
        return Build.VERSION.RELEASE;
    }
}

