/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.net;

import com.hisun.phone.core.voice.util.Log4Util;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

@Deprecated
public final class HttpHelper {
    private static final String TAG = "HttpHelper";
    public static final int SKIP_CACHE_NUM = 128;
    private static HttpClient httpClient;
    private static int sslPort;

    private static void ensureHttpClient() {
        httpClient = HttpHelper.newHttpClient();
    }

    static HttpClient newHttpClient() {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            SSLSocketFactoryEx sf = new SSLSocketFactoryEx(trustStore);
            sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)45000);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)30000);
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            registry.register(new Scheme("https", (SocketFactory)sf, sslPort <= 0 ? 8883 : sslPort));
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
            return new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
        }
        catch (Exception e) {
            Log4Util.e("SDK_DEVICE", e.toString());
            return new DefaultHttpClient();
        }
    }

    private static String stringFromInputStream(InputStream is) throws IOException {
        char[] buf = new char[1024];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, "UTF-8");
        int bin = 0;
        while ((bin = ((Reader)in).read(buf, 0, buf.length)) >= 0) {
            out.append(buf, 0, bin);
        }
        ((Reader)in).close();
        return out.toString();
    }

    @Deprecated
    public static String httpGet(String url, HashMap<String, String> headers) throws Exception {
        HttpHelper.ensureHttpClient();
        HttpGet request = new HttpGet(url);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            request.setHeader(key, value);
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Log4Util.d(TAG, "httpGet success.");
                return HttpHelper.stringFromInputStream(response.getEntity().getContent());
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    @Deprecated
    public static String httpPost(String url, HashMap<String, String> headers, String requestBody) throws Exception {
        HttpResponse response;
        HttpHelper.ensureHttpClient();
        HttpPost httpRequest = new HttpPost(url);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            httpRequest.setHeader(key, value);
        }
        if (requestBody != null) {
            ByteArrayEntity entity = new ByteArrayEntity(requestBody.getBytes());
            Log4Util.d("SDK_DEVICE", requestBody);
            httpRequest.setEntity((HttpEntity)entity);
        }
        if ((response = httpClient.execute((HttpUriRequest)httpRequest)) != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            Log4Util.d("SDK_DEVICE", "httpPost request return " + statusCode);
            if (statusCode == 200) {
                return HttpHelper.stringFromInputStream(response.getEntity().getContent());
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    @Deprecated
    public static String httpPost(String url) throws Exception {
        HttpHelper.ensureHttpClient();
        HttpPost httpRequest = new HttpPost(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            Log4Util.d("SDK_DEVICE", "httpPost request return " + statusCode);
            if (statusCode == 200) {
                return HttpHelper.stringFromInputStream(response.getEntity().getContent());
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    @Deprecated
    public static String httpUploadFile(String url, HashMap<String, String> headers, byte[] requestBody) throws Exception {
        HttpHelper.ensureHttpClient();
        HttpPost httpRequest = new HttpPost(url);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            httpRequest.setHeader(key, value);
        }
        ByteArrayEntity entity = new ByteArrayEntity(requestBody);
        Log4Util.d("SDK_DEVICE", requestBody.toString());
        httpRequest.setEntity((HttpEntity)entity);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            Log4Util.w("SDK_DEVICE", "httpPost request return " + statusCode);
            if (statusCode == 200) {
                return HttpHelper.stringFromInputStream(response.getEntity().getContent());
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    public static int getSSLPort() {
        return sslPort;
    }

    public static void setSSLPort(int port) {
        sslPort = port;
        Log4Util.d("SDK_DEVICE", "HttpHelper ssl port: " + sslPort);
    }

    public static boolean httpDowload(String url, String svaePath) throws Exception {
        HttpHelper.ensureHttpClient();
        HttpGet request = new HttpGet(url);
        String fileName = url.substring(url.lastIndexOf("/") + 1, url.length());
        if (fileName == null) {
            throw new Exception("This download url is invalid.");
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Log4Util.w(TAG, "dowload file from " + url + " success.");
                return HttpHelper.saveFromInputStream(response.getEntity().getContent(), svaePath);
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    public static int httpDowloadFile(String url, String svaePath) throws Exception {
        HttpHelper.ensureHttpClient();
        HttpGet request = new HttpGet(url);
        String fileName = url.substring(url.lastIndexOf("/") + 1, url.length());
        if (fileName == null) {
            throw new Exception("This download url is invalid.");
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Log4Util.w(TAG, "dowload file from " + url + " success.");
                boolean result = HttpHelper.saveFromInputStream(response.getEntity().getContent(), svaePath);
                return result ? 0 : 170011;
            }
            if (statusCode == 404) {
                return 170017;
            }
            Log4Util.d("SDK_DEVICE", "Got error code " + statusCode + " from server.");
            return statusCode;
        }
        throw new Exception("Unable to connect to server.");
    }

    private static boolean saveFromInputStream(InputStream content, String fileName) {
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            byte[] b = new byte[131072];
            int len = 0;
            while ((len = content.read(b)) != -1) {
                out.write(b, 0, len);
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Deprecated
    public static String httpPut(String url, HashMap<String, String> headers, String requestBody) throws Exception {
        HttpHelper.ensureHttpClient();
        HttpPut httpRequest = new HttpPut(url);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            httpRequest.setHeader(key, value);
        }
        ByteArrayEntity entity = new ByteArrayEntity(requestBody.getBytes());
        Log4Util.d("SDK_DEVICE", requestBody);
        httpRequest.setEntity((HttpEntity)entity);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            Log4Util.w("SDK_DEVICE", "HttpPut request return " + statusCode);
            if (statusCode == 200) {
                return HttpHelper.stringFromInputStream(response.getEntity().getContent());
            }
            throw new Exception("Got error code " + statusCode + " from server.");
        }
        throw new Exception("Unable to connect to server.");
    }

    static {
        sslPort = 0;
    }

    static class SSLSocketFactoryEx
    extends SSLSocketFactory {
        SSLContext sslContext = SSLContext.getInstance("TLS");

        public SSLSocketFactoryEx(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            this.sslContext.init(null, new TrustManager[]{tm}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }
}

