/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.multimedia;

import com.hisun.phone.core.voice.model.RecordProduct;
import com.hisun.phone.core.voice.util.Log4Util;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class RecordBlockingQueue {
    private static RecordBlockingQueue instance;
    BlockingQueue<RecordProduct> queue = new LinkedBlockingQueue<RecordProduct>();

    public static RecordBlockingQueue getInstance() {
        if (instance == null) {
            instance = new RecordBlockingQueue();
        }
        return instance;
    }

    public void produce(RecordProduct data) throws InterruptedException {
        this.queue.put(data);
        if (data.productType == RecordProduct.RecordProductType.ProductData) {
            Log4Util.d("SDK_DEVICE", "put type:" + (Object)((Object)data.productType) + ";data length:" + data.data.length);
        } else {
            Log4Util.d("SDK_DEVICE", "put type:" + (Object)((Object)data.productType));
        }
    }

    public RecordProduct consume() throws InterruptedException {
        RecordProduct take = this.queue.take();
        if (take.productType == RecordProduct.RecordProductType.ProductData) {
            Log4Util.d("SDK_DEVICE", "take type=" + (Object)((Object)take.productType) + ";data length:" + take.data.length);
        } else {
            Log4Util.d("SDK_DEVICE", "take type:" + (Object)((Object)take.productType));
        }
        return take;
    }

    public void clear() {
        this.queue.clear();
    }
}

