/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.multimedia;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioRecord;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import com.CCP.phone.NativeInterface;
import com.hisun.phone.core.voice.CCPCallImpl;
import com.hisun.phone.core.voice.CallControlManager;
import com.hisun.phone.core.voice.DeviceImpl;
import com.hisun.phone.core.voice.multimedia.CCPAudioRecorder;
import com.hisun.phone.core.voice.multimedia.RecordConsumer;
import com.hisun.phone.core.voice.util.AdaptationTools;
import com.hisun.phone.core.voice.util.Log4Util;
import com.hisun.phone.core.voice.util.VoiceUtil;

public class AudioRecordManager {
    private Context mContext;
    public static String AUDIOT_RECORD_TIME_OUT;
    public static final boolean DEBUG_RECORD = true;
    private static final int DEFAULT_MAX_DURATION = 60000;
    private static final int WHAT_ON_RECORDING_AMPLITUDE = 1;
    private static AudioRecordManager mInstance;
    private int bufferSizeInBytes = 0;
    private int mLocks = 0;
    private DeviceImpl listener;
    private AlarmManager alarmManager;
    private RecordTimeoutReceiver receiver;
    private CCPAudioRecorder mAudRecord;
    CallControlManager callControlManager;
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            int what = msg.what;
            if (what == 1 && AudioRecordManager.this.mAudRecord != null && AudioRecordManager.this.mAudRecord.getState() == CCPAudioRecorder.State.RECORDING) {
                int maxAmplitude = AudioRecordManager.this.mAudRecord.getMaxAmplitude();
                double amplitude = maxAmplitude % 100;
                if (amplitude > 0.0) {
                    // empty if block
                }
                if (AudioRecordManager.this.listener != null) {
                    AudioRecordManager.this.listener.onRecordingAmplitude(amplitude);
                }
                this.sendEmptyMessageDelayed(1, 200L);
            }
            super.handleMessage(msg);
        }
    };
    private int mSampleRate;
    private short mAudioFormat;
    private short mChannelConfig;

    public static synchronized AudioRecordManager getInstance() {
        if (mInstance == null) {
            mInstance = new AudioRecordManager();
        }
        return mInstance;
    }

    private AudioRecordManager() {
        this.mContext = CCPCallImpl.getInstance().getContext();
        this.alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.callControlManager = CCPCallImpl.getInstance().getCallControlManager();
        AUDIOT_RECORD_TIME_OUT = VoiceUtil.getPackageName(this.mContext) + ".intent.AUDIOT_RECORD_TIME_OUT";
        IntentFilter filter = new IntentFilter(AUDIOT_RECORD_TIME_OUT);
        this.receiver = new RecordTimeoutReceiver();
        this.mContext.registerReceiver((BroadcastReceiver)this.receiver, filter);
        RecordConsumer.getInstance();
        Log4Util.d("SDK_DEVICE", "[AudioRecordManager - Construction method ] this buffer size : " + this.bufferSizeInBytes);
    }

    public void startRecord(String uniqueID, String fileName) {
        this.initRecording(uniqueID, false, fileName, null, null);
    }

    public void startRecord(String uniqueID, String fileName, String groupId, String userData) {
        this.initRecording(uniqueID, true, fileName, groupId, userData);
    }

    synchronized void initRecording(String uniqueID, boolean isChunked, String fileName, String groupId, String userData) {
        if (this.mAudRecord != null && this.mAudRecord.getState() != CCPAudioRecorder.State.STOPPED) {
            return;
        }
        if (this.mLocks == 0) {
            this.mAudRecord = new CCPAudioRecorder(1, CCPAudioRecorder.sampleRates[4], 2, 2, isChunked);
            this.mAudRecord.setOutputFile(fileName);
            this.mAudRecord.setSendParameters(groupId, userData, uniqueID);
            this.mAudRecord.prepare();
            this.mAudRecord.start();
            long triggerAtTime = SystemClock.elapsedRealtime() + 60000L + 100L;
            this.setAlarmTime(triggerAtTime, AUDIOT_RECORD_TIME_OUT);
            if (this.handler != null) {
                this.handler.sendEmptyMessage(1);
            }
            if (!AdaptationTools.callNoiseSuppression()) {
                NativeInterface.InitAudioDevice();
            }
            ++this.mLocks;
        }
        Log4Util.i("initRecording mLocks " + this.mLocks);
    }

    public void cancleRecord(boolean isCancle) {
        if (this.mAudRecord != null) {
            this.mAudRecord.cancleEnable(isCancle);
        }
    }

    public synchronized void stopRecord() {
        if (this.mAudRecord != null) {
            Log4Util.i("stopRecord mAudRecord.getState() " + (Object)((Object)this.mAudRecord.getState()));
        }
        if (this.mAudRecord != null && this.mAudRecord.getState() == CCPAudioRecorder.State.RECORDING) {
            --this.mLocks;
            Log4Util.i("stopRecord mLocks " + this.mLocks);
            if (this.mLocks == 0) {
                this.mAudRecord.stop();
                this.mAudRecord.release();
                this.mAudRecord = null;
                this.cancelAlarmTime(AUDIOT_RECORD_TIME_OUT);
            }
            if (!AdaptationTools.callNoiseSuppression()) {
                NativeInterface.UNInitAudioDevice();
            }
        } else {
            this.mLocks = 0;
        }
    }

    public void release() {
        if (this.mContext != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.receiver);
            this.receiver = null;
        }
        this.handler = null;
        this.cancelAlarmTime(AUDIOT_RECORD_TIME_OUT);
        this.mAudRecord = null;
        mInstance = null;
    }

    public DeviceImpl getListener() {
        return this.listener;
    }

    public void setListener(DeviceImpl listener) {
        this.listener = listener;
    }

    public int getMaxDuration() {
        return 60000;
    }

    private void setAlarmTime(long triggerAtTime, String action) {
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(action), (int)0x8000000);
        this.alarmManager.set(3, triggerAtTime, pendingIntent);
    }

    private void cancelAlarmTime(String action) {
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(action), (int)0x10000000);
        this.alarmManager.cancel(pendingIntent);
    }

    @Deprecated
    public void createAudioRecord() {
        if (this.mSampleRate > 0 && this.mAudioFormat > 0 && this.mChannelConfig > 0) {
            return;
        }
        for (int sampleRate : new int[]{8000, 11025, 16000, 22050, 32000, 44100, 47250, 48000}) {
            for (short audioFormat : new short[]{2, 3}) {
                for (short channelConfig : new short[]{16, 12, 2, 3}) {
                    try {
                        AudioRecord mAudioRecord;
                        int mBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat);
                        if (mBufferSize < 0 || (mAudioRecord = new AudioRecord(1, sampleRate, (int)channelConfig, (int)audioFormat, mBufferSize)).getState() != 1) continue;
                        this.mSampleRate = sampleRate;
                        this.mAudioFormat = audioFormat;
                        this.mChannelConfig = channelConfig;
                        Log4Util.d("SDK_DEVICE", "[initRecorder ] mSampleRate :" + this.mSampleRate + " , mAudioFormat:" + this.mAudioFormat + " , mChannelConfig:" + this.mChannelConfig);
                        mAudioRecord.release();
                        mAudioRecord = null;
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        throw new IllegalStateException("getInstance() failed : no suitable audio configurations on this device.");
    }

    static {
        mInstance = null;
    }

    class RecordTimeoutReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if (intent == null || context == null) {
                return;
            }
            String action = intent.getAction() == null ? "" : intent.getAction();
            Log4Util.w("SDK_DEVICE", "[AudioRecordManager - onReceive] action = " + action);
            if (action.equals(AUDIOT_RECORD_TIME_OUT)) {
                if (AudioRecordManager.this.mLocks == 0) {
                    return;
                }
                AudioRecordManager.this.stopRecord();
                if (AudioRecordManager.this.listener != null) {
                    AudioRecordManager.this.listener.onRecordingTimeOut(60000L);
                }
                AudioRecordManager.this.cancelAlarmTime(AUDIOT_RECORD_TIME_OUT);
            }
        }
    }
}

