/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.net;

import android.os.Build;
import android.text.TextUtils;
import com.hisun.phone.core.voice.model.RecordProduct;
import com.hisun.phone.core.voice.multimedia.CCPAudioRecorder;
import com.hisun.phone.core.voice.multimedia.RecordBlockingQueue;
import com.hisun.phone.core.voice.util.Log4Util;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpClientUtil {
    private HttpClientUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postRequestUploadChunk(String reqURL) {
        HttpURLConnection httpURLConnection = null;
        DataOutputStream out = null;
        InputStream in = null;
        int httpStatusCode = 0;
        try {
            URL sendUrl = new URL(reqURL);
            httpURLConnection = (HttpURLConnection)sendUrl.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            httpURLConnection.setRequestProperty("Transfer-Encoding", "chunked");
            httpURLConnection.setRequestProperty("Accept", "application/xml");
            if (Build.VERSION.SDK_INT > 13) {
                httpURLConnection.setRequestProperty("Connection", "close");
            }
            if (Build.VERSION.SDK_INT < 8) {
                System.setProperty("http.keepAlive", "false");
            }
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setConnectTimeout(60000);
            httpURLConnection.setReadTimeout(60000);
            httpURLConnection.setChunkedStreamingMode(650);
            out = new DataOutputStream(httpURLConnection.getOutputStream());
            RecordBlockingQueue instance = RecordBlockingQueue.getInstance();
            RecordProduct product = instance.consume();
            while (product.productType != RecordProduct.RecordProductType.ProductEnd) {
                if (product.productType == RecordProduct.RecordProductType.ProductData) {
                    out.write(product.data, 0, product.data.length);
                    out.flush();
                }
                product = instance.consume();
            }
            out.close();
            Log4Util.d("SDK_DEVICE", "over");
            httpStatusCode = httpURLConnection.getResponseCode();
            Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestUploadChunk] httpStatusCode : " + httpStatusCode + " , body:" + httpURLConnection.getResponseMessage());
            if (httpStatusCode == 200) {
                in = httpURLConnection.getInputStream();
                String stringFromInputStream = HttpClientUtil.stringFromInputStream(in);
                in.close();
                String string = stringFromInputStream;
                return string;
            }
            try {
                throw new Exception("Got error code " + in + " from server.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestUploadChunk]  httpURLConnection disconnect");
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
                httpURLConnection = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int postRequestDownload(String url, String svaePath) {
        HttpURLConnection httpsURLConnection = null;
        InputStream in = null;
        int httpStatusCode = 0;
        try {
            URL sendUrl = new URL(url);
            httpsURLConnection = (HttpURLConnection)sendUrl.openConnection();
            httpsURLConnection.setRequestMethod("GET");
            httpsURLConnection.setRequestProperty("Accept", "application/octet-stream");
            httpsURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpsURLConnection.setDoOutput(false);
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setConnectTimeout(60000);
            httpsURLConnection.setReadTimeout(60000);
            httpsURLConnection.connect();
            httpStatusCode = httpsURLConnection.getResponseCode();
            Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestDownload] : " + httpStatusCode + " , body:" + httpsURLConnection.getResponseMessage());
            if (httpStatusCode == 200) {
                in = httpsURLConnection.getInputStream();
                httpStatusCode = HttpClientUtil._saveFromInputStream(in, svaePath) ? 0 : 170016;
            } else {
                if (httpStatusCode == 404) {
                    int n = 170017;
                    return n;
                }
                Log4Util.i("SDK_DEVICE", "[HttpClientUtil - postRequestDownload] Got error code " + in + " from server.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            httpStatusCode = 170011;
        }
        catch (Exception e) {
            e.printStackTrace();
            new File(svaePath).deleteOnExit();
            Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestDownload] : Don't read data flow normal end marker, notice of cancellation , and delete local voice file .");
            httpStatusCode = 170005;
        }
        finally {
            if (httpsURLConnection != null) {
                httpsURLConnection.disconnect();
                httpsURLConnection = null;
            }
        }
        return httpStatusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postRequestUploadFileChunk(String reqURL, String fileName) {
        HttpURLConnection httpURLConnection = null;
        DataOutputStream out = null;
        InputStream in = null;
        int httpStatusCode = 0;
        try {
            URL sendUrl = new URL(reqURL);
            httpURLConnection = (HttpURLConnection)sendUrl.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            httpURLConnection.setRequestProperty("Transfer-Encoding", "chunked");
            httpURLConnection.setRequestProperty("Accept", "application/xml");
            if (Build.VERSION.SDK_INT > 13) {
                httpURLConnection.setRequestProperty("Connection", "close");
            }
            if (Build.VERSION.SDK_INT < 8) {
                System.setProperty("http.keepAlive", "false");
            }
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setConnectTimeout(60000);
            httpURLConnection.setReadTimeout(60000);
            httpURLConnection.setChunkedStreamingMode(650);
            out = new DataOutputStream(httpURLConnection.getOutputStream());
            FileInputStream fis = new FileInputStream(fileName);
            byte[] buffer = new byte[131072];
            int len = 0;
            int size = 0;
            while ((len = fis.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestUploadFileChunk] The total sent files :  " + (size += len) + " bytes. ");
            }
            fis.close();
            out.close();
            Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestUploadFileChunk] Upload file end, close the input and output streams .");
            httpStatusCode = httpURLConnection.getResponseCode();
            Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestUploadFileChunk] httpStatusCode : " + httpStatusCode + " , body:" + httpURLConnection.getResponseMessage());
            if (httpStatusCode == 200) {
                in = httpURLConnection.getInputStream();
                String stringFromInputStream = HttpClientUtil.stringFromInputStream(in);
                in.close();
                Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestUploadFileChunk] Read the server returned to upload results information, and then close the input stream .");
                String string = stringFromInputStream;
                return string;
            }
            try {
                throw new Exception("Got error code " + in + " from server.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestUploadFileChunk] httpURLConnection disconnect");
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
                httpURLConnection = null;
            }
        }
        return null;
    }

    private static String stringFromInputStream(InputStream is) throws IOException {
        char[] buf = new char[1024];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(is, "UTF-8");
        int bin = 0;
        while ((bin = ((Reader)in).read(buf, 0, buf.length)) >= 0) {
            out.append(buf, 0, bin);
        }
        ((Reader)in).close();
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean _saveFromInputStream(InputStream content, String fileName) throws IOException {
        RandomAccessFile markRead = null;
        try {
            String markStr;
            markRead = new RandomAccessFile(fileName, "rw");
            byte[] b = new byte[1024];
            int len = 0;
            int totalLength = 0;
            while ((len = content.read(b)) != -1) {
                totalLength += len;
                markRead.write(b, 0, len);
                Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestDownload] : read data byte size :" + len);
            }
            byte[] mark = new byte[12];
            if (totalLength >= 12) {
                markRead.seek(totalLength - 12);
                markRead.read(mark);
            }
            if (HttpClientUtil.isAmrMark(markStr = new String(mark))) {
                Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestDownload] : read data byte over , mark is : " + markStr.substring(1, markStr.length()));
                boolean bl = true;
                return bl;
            }
            new File(fileName).deleteOnExit();
            Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestDownload] : read amr marke error, mark :  " + markStr + ", and delete local voice file .");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (markRead != null) {
                markRead.close();
                markRead = null;
            }
        }
        return false;
    }

    static boolean hasStopMark(byte[] toCompare) {
        if (toCompare == null || toCompare.length != 11) {
            return false;
        }
        for (int i = 0; i < 11; ++i) {
            if (CCPAudioRecorder.AMR_STOP[i] == toCompare[i]) continue;
            return false;
        }
        return true;
    }

    static boolean isAmrMark(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        return str.endsWith(new String(CCPAudioRecorder.AMR_STOP));
    }

    @Deprecated
    static boolean saveFromInputStream(InputStream content, String fileName) throws IOException {
        FileOutputStream out = new FileOutputStream(fileName);
        byte[] b = new byte[1024];
        int len = 0;
        int lastLength = 0;
        while ((len = content.read(b)) != -1) {
            lastLength = len;
            out.write(b, 0, len);
            Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestDownload] : read data byte size :" + len);
        }
        byte[] stop = new byte[11];
        if (lastLength >= 11) {
            System.arraycopy(b, lastLength - 11, stop, 0, 11);
            if (HttpClientUtil.hasStopMark(stop)) {
                String amrStop = new String(stop);
                Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestDownload] : read data byte over , mark is : " + amrStop);
                return true;
            }
            Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestDownload] : read data byte over , mark is : " + new String(stop));
        } else {
            new File(fileName).deleteOnExit();
        }
        Log4Util.d("SDK_DEVICE", "[HttpClientUtil - postRequestDownload] : Don't read data flow normal end marker, notice of cancellation , and delete local voice file .");
        return false;
    }
}

