/*
 * Decompiled with CFR 0.152.
 */
package com.hisun.phone.core.voice.multimedia;

import android.media.MediaRecorder;
import android.os.Handler;
import android.os.Message;
import com.hisun.phone.core.voice.DeviceImpl;

public class RecordManager {
    public static final int DEFAULT_MAX_DURATION = 60000;
    public static final int FILE_FORMAT = 3;
    public static final int AUDIO_CODEC = 1;
    private static RecordManager mInstance = null;
    private MediaRecorder mRec = null;
    boolean mRecording = false;
    private DeviceImpl listener;
    Handler handler = new Handler(){
        int time = 0;

        public void handleMessage(Message msg) {
            if (RecordManager.this.mRecording) {
                if (RecordManager.this.listener != null) {
                    double amp = 0.0;
                    if (RecordManager.this.mRec != null) {
                        amp = RecordManager.this.mRec.getMaxAmplitude();
                    }
                    RecordManager.this.listener.onRecordingAmplitude(amp);
                    if (this.time >= 60000) {
                        RecordManager.this.listener.onRecordingTimeOut(60000L);
                    }
                }
                this.time += 100;
                this.sendEmptyMessageDelayed(1, 100L);
            } else {
                this.time = 0;
            }
            super.handleMessage(msg);
        }
    };

    public static synchronized RecordManager getInstance() {
        if (null == mInstance) {
            mInstance = new RecordManager();
        }
        return mInstance;
    }

    private RecordManager() {
    }

    public int getMaxDuration() {
        return 60000;
    }

    public void setLisenter(DeviceImpl listener) {
        this.listener = listener;
    }

    public void startRecord(String fileName) throws Exception {
        this.mRec = new MediaRecorder();
        this.mRec.setAudioSource(1);
        this.mRec.setOutputFormat(3);
        this.mRec.setAudioEncoder(1);
        this.mRec.setAudioChannels(1);
        this.mRec.setAudioEncodingBitRate(16);
        this.mRec.setOutputFile(fileName);
        this.mRec.setMaxDuration(this.getMaxDuration());
        this.handler.sendEmptyMessageDelayed(1, 100L);
        try {
            this.mRec.prepare();
            this.mRec.start();
            this.mRecording = true;
        }
        catch (Exception e) {
            this.mRec.release();
            this.mRec = null;
            this.mRecording = false;
            throw e;
        }
    }

    public void stopRecord() {
        if (this.mRecording) {
            this.mRecording = false;
            if (null != this.mRec) {
                this.mRec.stop();
                this.mRec.release();
                this.mRec = null;
            }
        }
    }

    public void release() {
        if (this.mRec != null) {
            this.mRec.stop();
            this.mRec.release();
        }
        this.mRec = null;
    }
}

