/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.manager;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import com.CCP.phone.NativeInterface;
import com.useasy.callsdk.CallSDK;
import com.useasy.callsdk.NativeCallInterface;
import com.useasy.callsdk.bean.SipParams;
import com.useasy.callsdk.constant.ErrorCode;
import com.useasy.callsdk.impl.NativeCallInterfaceImpl;
import com.useasy.callsdk.listener.CallEventCallback;
import com.useasy.callsdk.listener.CallStateListener;
import com.useasy.callsdk.manager.CallManager;
import com.useasy.callsdk.utils.AudioUtils;
import com.useasy.callsdk.utils.Loger;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u001d\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u000fH\u0002J\u0015\u0010\"\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b#J\r\u0010$\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b%J.\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u000f2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0017\u0010*\u001a\u00020'2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b+J\u001f\u0010,\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010-\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020'H\u0000\u00a2\u0006\u0002\b0J%\u00101\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b2J!\u00103\u001a\u0004\u0018\u00010\u00112\u0006\u00104\u001a\u00020\u00112\b\u00105\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b6J\u0016\u00107\u001a\u00020'2\f\u00108\u001a\b\u0012\u0004\u0012\u00020'09H\u0002J\u001f\u0010:\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010;\u001a\u00020<H\u0000\u00a2\u0006\u0002\b=J\u0015\u0010>\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b@J\b\u0010A\u001a\u00020'H\u0002J\u0015\u0010B\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\bCR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/useasy/callsdk/manager/CallManager;", "", "()V", "currentCallStateListener", "Lcom/useasy/callsdk/listener/CallStateListener;", "isCallInitialized", "", "isLocalHangupHandled", "mainHandler", "Landroid/os/Handler;", "nativeCallInterface", "Lcom/useasy/callsdk/NativeCallInterface;", "pendingSipParams", "Lcom/useasy/callsdk/bean/SipParams;", "acceptCall", "", "callId", "", "acceptCall$callsdk_release", "createCallEventCallbackAdapter", "Lcom/useasy/callsdk/listener/CallEventCallback;", "listener", "sipParams", "enableLoudsSpeaker", "context", "Landroid/content/Context;", "enable", "enableLoudsSpeaker$callsdk_release", "getCallStateName", "state", "getCurrentCall", "getCurrentCall$callsdk_release", "getEventName", "event", "getLoudsSpeakerStatus", "getLoudsSpeakerStatus$callsdk_release", "getMuteStatus", "getMuteStatus$callsdk_release", "handleCallState", "", "message", "", "handleHangupFromSocket", "handleHangupFromSocket$callsdk_release", "hangupCall", "reason", "hangupCall$callsdk_release", "init", "init$callsdk_release", "initCall", "initCall$callsdk_release", "makeCall", "phoneNumber", "userData", "makeCall$callsdk_release", "postToMain", "block", "Lkotlin/Function0;", "sendDTMF", "dtmf", "", "sendDTMF$callsdk_release", "setMute", "mute", "setMute$callsdk_release", "startCallAfterConnected", "unInitializeCall", "unInitializeCall$callsdk_release", "callsdk_release"})
public final class CallManager {
    private static final NativeCallInterface nativeCallInterface;
    private static boolean isCallInitialized;
    private static SipParams pendingSipParams;
    private static CallStateListener currentCallStateListener;
    private static volatile boolean isLocalHangupHandled;
    private static final Handler mainHandler;
    @NotNull
    public static final CallManager INSTANCE;

    private final String getEventName(int event) {
        String string;
        switch (event) {
            case 0: {
                string = "MESSAGE";
                break;
            }
            case 1: {
                string = "CONNECT";
                break;
            }
            case 2: {
                string = "DISCONNECT";
                break;
            }
            case 3: {
                string = "CALL";
                break;
            }
            case 4: {
                string = "DTMF_RECEIVED";
                break;
            }
            case 5: {
                string = "GET_CAPABILITY_TOKEN";
                break;
            }
            case 6: {
                string = "LOG_INFO";
                break;
            }
            case 7: {
                string = "MESSAGE_REPORT";
                break;
            }
            case 8: {
                string = "GENERAL";
                break;
            }
            case 9: {
                string = "GROUP_MESSAGE";
                break;
            }
            case 11: {
                string = "RECORD_CALL_VOICE";
                break;
            }
            case 12: {
                string = "AUDIO_DATA_PROCESS";
                break;
            }
            case 14: {
                string = "ORIGINAL_AUDIO_DATA_PROCESS";
                break;
            }
            case 16: {
                string = "ENABLE_SRTP";
                break;
            }
            case 19: {
                string = "LOGOUT";
                break;
            }
            case 20: {
                string = "REINIT";
                break;
            }
            default: {
                string = "UNKNOWN(" + event + ')';
            }
        }
        return string;
    }

    private final String getCallStateName(int state) {
        String string;
        switch (state) {
            case 0: {
                string = "SUCCESS/OK";
                break;
            }
            case 1: {
                string = "MAKE_CALL_FAILED";
                break;
            }
            case 2: {
                string = "INCOMING";
                break;
            }
            case 3: {
                string = "ALERTING";
                break;
            }
            case 4: {
                string = "ANSWERED";
                break;
            }
            case 5: {
                string = "PAUSED";
                break;
            }
            case 6: {
                string = "REMOTE_PAUSED";
                break;
            }
            case 7: {
                string = "RELEASED";
                break;
            }
            case 8: {
                string = "TRANSFERRED";
                break;
            }
            case 10: {
                string = "PROCEEDING";
                break;
            }
            default: {
                string = "UNKNOWN(" + state + ')';
            }
        }
        return string;
    }

    private final void postToMain(Function0<Unit> block) {
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            block.invoke();
        } else {
            mainHandler.post(new Runnable(block){
                final /* synthetic */ Function0 $block;

                public final void run() {
                    this.$block.invoke();
                }
                {
                    this.$block = function0;
                }
            });
        }
    }

    public final void init$callsdk_release() {
        nativeCallInterface.init();
    }

    public final int initCall$callsdk_release(@NotNull Context context, @NotNull SipParams sipParams, @NotNull CallStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sipParams, (String)"sipParams");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        currentCallStateListener = listener;
        pendingSipParams = sipParams;
        if (isCallInitialized) {
            Loger.iTag("CallManager", "Call already initialized, reconnect with new SIP params");
            return nativeCallInterface.connectToCCP(sipParams);
        }
        CallEventCallback callback = this.createCallEventCallbackAdapter(listener, sipParams);
        nativeCallInterface.init();
        nativeCallInterface.setStunServer("stun.freeswitch.org");
        nativeCallInterface.setTraceFlag(CallSDK.getConfig().getLogConfig().getEnableLog() && CallSDK.getConfig().getLogConfig().getConsoleLogEnabled());
        nativeCallInterface.setCallBackParams(callback);
        nativeCallInterface.initialize();
        nativeCallInterface.setAudioContext(context);
        nativeCallInterface.setLogLevel(CallSDK.getConfig().getLogConfig().getLogLevel());
        nativeCallInterface.amrNBCreateEnc();
        nativeCallInterface.amrNBEncoderInit(0);
        nativeCallInterface.setDtxEnabled(true);
        NativeInterface.setAudioConfig((int)0, (boolean)true, (int)4);
        NativeInterface.setAudioConfig((int)1, (boolean)true, (int)4);
        NativeInterface.setAudioConfig((int)2, (boolean)true, (int)6);
        int result = nativeCallInterface.connectToCCP(sipParams);
        if (result == 0) {
            isCallInitialized = true;
        }
        return result;
    }

    private final CallEventCallback createCallEventCallbackAdapter(CallStateListener listener, SipParams sipParams) {
        return new CallEventCallback(listener){
            final /* synthetic */ CallStateListener $listener;

            @Nullable
            public Object onCallEvent(int event, @Nullable String id, @Nullable byte[] message, int state) {
                Object object;
                Object object2;
                String eventName = CallManager.access$getEventName(CallManager.INSTANCE, event);
                String stateName = CallManager.access$getCallStateName(CallManager.INSTANCE, state);
                if (message != null) {
                    object2 = message;
                    boolean bl = false;
                    byte[] byArray = object2;
                    boolean bl2 = false;
                    if (!(byArray.length == 0)) {
                        try {
                            Charset charset = Charsets.UTF_8;
                            boolean bl3 = false;
                            String messageStr = new String(message, charset);
                            object2 = "size=" + message.length + ", content=\"" + messageStr + '\"';
                        }
                        catch (Exception e) {
                            object2 = "size=" + message.length + ", firstByte=" + message[0] + ", parseError=" + e.getMessage();
                        }
                        object = object2;
                    } else {
                        object = "empty";
                    }
                } else {
                    object = "null";
                }
                String messageInfo = object;
                Loger.iTag("CallManager", "onCallEvent: event=" + eventName + '(' + event + "), callId=" + id + ", message=" + messageInfo + ", state=" + stateName + '(' + state + ')');
                switch (event) {
                    case 1: {
                        if (state == 0) {
                            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(this){
                                final /* synthetic */ createCallEventCallbackAdapter.1 this$0;

                                public final void run() {
                                    CallManager.access$startCallAfterConnected(CallManager.INSTANCE);
                                    this.this$0.$listener.onConnected();
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }, 100L);
                            break;
                        }
                        CallManager.access$postToMain(CallManager.INSTANCE, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ createCallEventCallbackAdapter.1 this$0;

                            public final void invoke() {
                                this.this$0.$listener.onDisconnected();
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                        break;
                    }
                    case 2: {
                        CallManager.access$postToMain(CallManager.INSTANCE, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ createCallEventCallbackAdapter.1 this$0;

                            public final void invoke() {
                                this.this$0.$listener.onDisconnected();
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                        break;
                    }
                    case 3: {
                        CallManager.access$handleCallState(CallManager.INSTANCE, this.$listener, id, state, message);
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 4: {
                        if (message != null) {
                            object2 = message;
                            boolean bl = false;
                            boolean bl4 = false;
                            Object it = object2;
                            boolean bl5 = false;
                            Object object3 = it;
                            boolean bl6 = false;
                            Object object4 = object3;
                            boolean bl7 = false;
                            if (!(!(((byte[])object4).length == 0))) break;
                            char dtmf = (char)it[0];
                            CallManager.access$postToMain(CallManager.INSTANCE, (Function0)new Function0<Unit>(dtmf, this, id){
                                final /* synthetic */ char $dtmf;
                                final /* synthetic */ createCallEventCallbackAdapter.1 this$0;
                                final /* synthetic */ String $id$inlined;
                                {
                                    this.$dtmf = c;
                                    this.this$0 = var2_2;
                                    this.$id$inlined = string;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.$listener.onDtmfReceived(this.$id$inlined, this.$dtmf);
                                }
                            });
                        }
                        break;
                    }
                }
                return null;
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        };
    }

    private final void startCallAfterConnected() {
        new Handler(Looper.getMainLooper()).postDelayed((Runnable)startCallAfterConnected.1.INSTANCE, 200L);
    }

    private final void handleCallState(CallStateListener listener, String callId, int state, byte[] message) {
        switch (state) {
            case 1: {
                nativeCallInterface.disConnectToCCP();
                Integer reasonCode = null;
                String messageStr = null;
                if (message != null) {
                    Object object = message;
                    boolean bl = false;
                    byte[] byArray = object;
                    boolean bl2 = false;
                    if (!(byArray.length == 0)) {
                        try {
                            object = Charsets.UTF_8;
                            bl = false;
                            messageStr = new String(message, (Charset)object);
                            reasonCode = StringsKt.toIntOrNull((String)messageStr);
                        }
                        catch (Exception e) {
                            Loger.wTag("CallManager", "Failed to parse reason code from message: " + e.getMessage());
                        }
                    }
                }
                if (Intrinsics.areEqual((Object)messageStr, (Object)"0")) {
                    Loger.iTag("CallManager", "\u68c0\u6d4b\u5230\u4e3b\u53eb\u6302\u65ad (message=0), callId=" + callId);
                    isLocalHangupHandled = true;
                    nativeCallInterface.disConnectToCCP();
                    this.postToMain((Function0<Unit>)((Function0)new Function0<Unit>(listener, callId){
                        final /* synthetic */ CallStateListener $listener;
                        final /* synthetic */ String $callId;

                        public final void invoke() {
                            this.$listener.onCallReleased(0, this.$callId);
                        }
                        {
                            this.$listener = callStateListener;
                            this.$callId = string;
                            super(0);
                        }
                    }));
                    return;
                }
                int errorCode = ErrorCode.INSTANCE.convertCallErrorCode(reasonCode);
                String errorMsg = ErrorCode.INSTANCE.getErrorMessage(errorCode);
                if (errorCode == -9999) break;
                this.postToMain((Function0<Unit>)((Function0)new Function0<Unit>(listener, callId, errorCode, errorMsg){
                    final /* synthetic */ CallStateListener $listener;
                    final /* synthetic */ String $callId;
                    final /* synthetic */ int $errorCode;
                    final /* synthetic */ String $errorMsg;

                    public final void invoke() {
                        this.$listener.onCallFailed(this.$callId, this.$errorCode, this.$errorMsg);
                    }
                    {
                        this.$listener = callStateListener;
                        this.$callId = string;
                        this.$errorCode = n;
                        this.$errorMsg = string2;
                        super(0);
                    }
                }));
                break;
            }
            case 2: {
                this.postToMain((Function0<Unit>)((Function0)new Function0<Unit>(listener, callId){
                    final /* synthetic */ CallStateListener $listener;
                    final /* synthetic */ String $callId;

                    public final void invoke() {
                        this.$listener.onIncomingCall(this.$callId);
                    }
                    {
                        this.$listener = callStateListener;
                        this.$callId = string;
                        super(0);
                    }
                }));
                break;
            }
            case 3: {
                this.postToMain((Function0<Unit>)((Function0)new Function0<Unit>(listener, callId){
                    final /* synthetic */ CallStateListener $listener;
                    final /* synthetic */ String $callId;

                    public final void invoke() {
                        this.$listener.onCallAlerting(this.$callId);
                    }
                    {
                        this.$listener = callStateListener;
                        this.$callId = string;
                        super(0);
                    }
                }));
                break;
            }
            case 4: {
                this.postToMain((Function0<Unit>)((Function0)new Function0<Unit>(listener, callId){
                    final /* synthetic */ CallStateListener $listener;
                    final /* synthetic */ String $callId;

                    public final void invoke() {
                        this.$listener.onCallAnswered(this.$callId);
                    }
                    {
                        this.$listener = callStateListener;
                        this.$callId = string;
                        super(0);
                    }
                }));
                break;
            }
            case 10: {
                this.postToMain((Function0<Unit>)((Function0)new Function0<Unit>(listener, callId){
                    final /* synthetic */ CallStateListener $listener;
                    final /* synthetic */ String $callId;

                    public final void invoke() {
                        this.$listener.onCallProceeding(this.$callId);
                    }
                    {
                        this.$listener = callStateListener;
                        this.$callId = string;
                        super(0);
                    }
                }));
                break;
            }
            case 7: {
                nativeCallInterface.disConnectToCCP();
                isLocalHangupHandled = true;
                this.postToMain((Function0<Unit>)((Function0)new Function0<Unit>(listener, callId){
                    final /* synthetic */ CallStateListener $listener;
                    final /* synthetic */ String $callId;

                    public final void invoke() {
                        this.$listener.onCallReleased(0, this.$callId);
                    }
                    {
                        this.$listener = callStateListener;
                        this.$callId = string;
                        super(0);
                    }
                }));
                break;
            }
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
    }

    static /* synthetic */ void handleCallState$default(CallManager callManager, CallStateListener callStateListener, String string, int n, byte[] byArray, int n2, Object object) {
        if ((n2 & 8) != 0) {
            byArray = null;
        }
        callManager.handleCallState(callStateListener, string, n, byArray);
    }

    @Nullable
    public final String makeCall$callsdk_release(@NotNull String phoneNumber, @Nullable String userData) {
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        isLocalHangupHandled = false;
        return nativeCallInterface.makeCall(phoneNumber, userData);
    }

    public final int hangupCall$callsdk_release(@Nullable String callId, int reason) {
        return nativeCallInterface.releaseCall(callId, reason);
    }

    public final boolean getMuteStatus$callsdk_release() {
        return nativeCallInterface.getMuteStatus();
    }

    public final int setMute$callsdk_release(boolean mute) {
        return nativeCallInterface.setMute(mute);
    }

    public final int sendDTMF$callsdk_release(@Nullable String callId, char dtmf) {
        return nativeCallInterface.sendDTMF(callId, dtmf);
    }

    @Nullable
    public final String getCurrentCall$callsdk_release() {
        return nativeCallInterface.getCurrentCall();
    }

    public final int acceptCall$callsdk_release(@Nullable String callId) {
        return nativeCallInterface.acceptCall(callId);
    }

    public final int enableLoudsSpeaker$callsdk_release(@NotNull Context context, boolean enable) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("audio");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
        }
        AudioManager audioManager = (AudioManager)object;
        audioManager.setMode(3);
        audioManager.setSpeakerphoneOn(enable);
        return 0;
    }

    public final boolean getLoudsSpeakerStatus$callsdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("audio");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
        }
        AudioManager audioManager = (AudioManager)object;
        audioManager.setMode(3);
        return audioManager.isSpeakerphoneOn();
    }

    public final int unInitializeCall$callsdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!isCallInitialized) {
            return 0;
        }
        isCallInitialized = false;
        currentCallStateListener = null;
        AudioUtils.dispose(context, unInitializeCall.1.INSTANCE);
        nativeCallInterface.unInitialize();
        return 0;
    }

    public final void handleHangupFromSocket$callsdk_release(@Nullable String callId) {
        Loger.iTag("CallManager", "\u6536\u5230 WebSocket hangup \u6d88\u606f, callId: " + callId + ", isLocalHangupHandled: " + isLocalHangupHandled);
        CallStateListener callStateListener = currentCallStateListener;
        if (callStateListener != null) {
            CallStateListener callStateListener2 = callStateListener;
            boolean bl = false;
            boolean bl2 = false;
            CallStateListener listener = callStateListener2;
            boolean bl3 = false;
            if (isLocalHangupHandled) {
                isLocalHangupHandled = false;
                return;
            }
            isLocalHangupHandled = false;
            nativeCallInterface.disConnectToCCP();
            INSTANCE.postToMain((Function0<Unit>)((Function0)new Function0<Unit>(listener, callId){
                final /* synthetic */ CallStateListener $listener;
                final /* synthetic */ String $callId$inlined;
                {
                    this.$listener = callStateListener;
                    this.$callId$inlined = string;
                    super(0);
                }

                public final void invoke() {
                    this.$listener.onCallReleased(1, this.$callId$inlined);
                }
            }));
        } else {
            CallManager callManager = this;
            boolean bl = false;
            boolean bl4 = false;
            CallManager $this$run = callManager;
            boolean bl5 = false;
            Loger.wTag("CallManager", "\u6ca1\u6709\u6ce8\u518c CallStateListener\uff0c\u65e0\u6cd5\u56de\u8c03 onCallReleased");
            isLocalHangupHandled = false;
        }
    }

    private CallManager() {
    }

    static {
        CallManager callManager;
        INSTANCE = callManager = new CallManager();
        nativeCallInterface = new NativeCallInterfaceImpl();
        mainHandler = new Handler(Looper.getMainLooper());
    }

    public static final /* synthetic */ String access$getEventName(CallManager $this, int event) {
        return $this.getEventName(event);
    }

    public static final /* synthetic */ String access$getCallStateName(CallManager $this, int state) {
        return $this.getCallStateName(state);
    }

    public static final /* synthetic */ void access$startCallAfterConnected(CallManager $this) {
        $this.startCallAfterConnected();
    }

    public static final /* synthetic */ void access$postToMain(CallManager $this, Function0 block) {
        $this.postToMain((Function0<Unit>)block);
    }

    public static final /* synthetic */ void access$handleCallState(CallManager $this, CallStateListener listener, String callId, int state, byte[] message) {
        $this.handleCallState(listener, callId, state, message);
    }

    public static final /* synthetic */ SipParams access$getPendingSipParams$p(CallManager $this) {
        CallManager callManager = $this;
        return pendingSipParams;
    }

    public static final /* synthetic */ void access$setPendingSipParams$p(CallManager $this, SipParams sipParams) {
        CallManager callManager = $this;
        pendingSipParams = sipParams;
    }

    public static final /* synthetic */ CallStateListener access$getCurrentCallStateListener$p(CallManager $this) {
        CallManager callManager = $this;
        return currentCallStateListener;
    }

    public static final /* synthetic */ void access$setCurrentCallStateListener$p(CallManager $this, CallStateListener callStateListener) {
        CallManager callManager = $this;
        currentCallStateListener = callStateListener;
    }
}

