/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk.http;

import com.useasy.callsdk.CallSDK;
import com.useasy.callsdk.config.SDKConfig;
import com.useasy.callsdk.constant.ErrorCode;
import com.useasy.callsdk.http.HttpManager;
import com.useasy.callsdk.listener.LoginListener;
import com.useasy.callsdk.listener.OnResponseListener;
import com.useasy.callsdk.utils.DeviceUtils;
import com.useasy.callsdk.utils.HttpParser;
import com.useasy.callsdk.utils.Loger;
import com.useasy.callsdk.utils.LoginHelper;
import com.useasy.callsdk.utils.SPUtils;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\u0018\u0000 E2\u00020\u0001:\u0001EB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020#H\u0002J\u0006\u0010$\u001a\u00020\u0004J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010'\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010(\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010)\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010*\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010+\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\b\b\u0002\u0010,\u001a\u00020\u0004H\u0002J$\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010,\u001a\u00020\u0004H\u0002J*\u00101\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00042\b\u00102\u001a\u0004\u0018\u00010\u00042\b\u00103\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u000204J,\u00105\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00042\b\u00102\u001a\u0004\u0018\u00010\u00042\b\u00103\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u000204H\u0002J \u00106\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u000204H\u0002J\u000e\u00107\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\"\u00108\u001a\u00020\u00192\b\b\u0002\u00109\u001a\u00020:2\b\b\u0002\u0010;\u001a\u00020:2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010<\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010?\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010A\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010C\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006F"}, d2={"Lcom/useasy/callsdk/http/HttpManager;", "", "()V", "baseUrl", "", "client", "Lokhttp3/OkHttpClient;", "jsonMediaType", "Lokhttp3/MediaType;", "getJsonMediaType", "()Lokhttp3/MediaType;", "jsonMediaType$delegate", "Lkotlin/Lazy;", "buildGetRequest", "Lokhttp3/Request;", "url", "buildGetRequestWithoutAuth", "buildPostRequest", "body", "Lokhttp3/RequestBody;", "buildPostRequestWithoutAuth", "createJsonBody", "json", "Lorg/json/JSONObject;", "dialOutInfo", "", "phoneNum", "agentId", "agentNumber", "accountId", "listener", "Lcom/useasy/callsdk/listener/OnResponseListener;", "executeRequest", "request", "getAuthHeaders", "Lokhttp3/Headers;", "getBaseUrl", "getCloudConfig", "username", "getFullAgent", "getLoginInfo", "getWebRtcInfo", "getWsToken", "logRequest", "tag", "logResponse", "response", "Lokhttp3/Response;", "responseBody", "login", "password", "passwordPk", "Lcom/useasy/callsdk/listener/LoginListener;", "loginInner", "performLogin", "queryDisplayNumberList", "queryNumberGroupList", "page", "", "pageSize", "riskQuery", "unregisterDeviceToken", "token", "updateAgentNumberGroup", "numberGroupId", "updateAgentSelectNumber", "selectNumber", "updateBaseUrl", "newBaseUrl", "Companion", "callsdk_release"})
public final class HttpManager {
    private final OkHttpClient client;
    private volatile String baseUrl;
    private final Lazy jsonMediaType$delegate = LazyKt.lazy((Function0)jsonMediaType.2.INSTANCE);
    private static volatile HttpManager instance;
    @NotNull
    public static final Companion Companion;

    private final MediaType getJsonMediaType() {
        Lazy lazy = this.jsonMediaType$delegate;
        HttpManager httpManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MediaType)lazy.getValue();
    }

    public final void updateBaseUrl(@NotNull String newBaseUrl) {
        Intrinsics.checkNotNullParameter((Object)newBaseUrl, (String)"newBaseUrl");
        this.baseUrl = newBaseUrl;
        Loger.iTag("HttpManager", "BaseUrl updated to: " + this.baseUrl);
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    private final Headers getAuthHeaders() {
        String loginToken = SPUtils.getString("loginToken", "");
        String sessionId = SPUtils.getString("sessionId", "");
        int clientType = SPUtils.getInt("clientType", 2);
        Headers headers = new Headers.Builder().add("Connection", "keep-alive").add("logintoken", loginToken).add("sessionid", sessionId).add("clienttype", String.valueOf(clientType)).add("Accept-Language", "zh-CN").build();
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"Headers.Builder()\n      \u2026CN\")\n            .build()");
        return headers;
    }

    private final Request buildGetRequest(String url) {
        Request request = new Request.Builder().url(url).headers(this.getAuthHeaders()).get().build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"Request.Builder()\n      \u2026et()\n            .build()");
        return request;
    }

    private final Request buildPostRequest(String url, RequestBody body) {
        Request request = new Request.Builder().url(url).headers(this.getAuthHeaders()).post(body).build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"Request.Builder()\n      \u2026ody)\n            .build()");
        return request;
    }

    private final Request buildGetRequestWithoutAuth(String url) {
        Request request = new Request.Builder().url(url).get().build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"Request.Builder()\n      \u2026et()\n            .build()");
        return request;
    }

    private final Request buildPostRequestWithoutAuth(String url, RequestBody body) {
        Request request = new Request.Builder().url(url).post(body).build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"Request.Builder()\n      \u2026ody)\n            .build()");
        return request;
    }

    private final Request logRequest(Request request, String tag) {
        String string = request.url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url().toString()");
        String url = string;
        String method = request.method();
        Headers headers = request.headers();
        StringBuilder headersStr = new StringBuilder();
        Set set = headers.names();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"headers.names()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            List list = headers.values(name);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"headers.values(name)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String value = (String)element$iv2;
                boolean bl2 = false;
                CharSequence charSequence = headersStr;
                boolean bl3 = false;
                if (charSequence.length() > 0) {
                    headersStr.append(", ");
                }
                headersStr.append(name + ": " + value);
            }
        }
        RequestBody body = request.body();
        Request newRequest = request;
        String bodyStr = "null";
        if (body != null) {
            try {
                Buffer buffer = new Buffer();
                body.writeTo((BufferedSink)buffer);
                String string2 = buffer.readUtf8();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buffer.readUtf8()");
                bodyStr = string2;
                MediaType mediaType = body.contentType();
                if (mediaType == null) {
                    mediaType = this.getJsonMediaType();
                }
                Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"body.contentType() ?: jsonMediaType");
                MediaType contentType = mediaType;
                RequestBody newBody = RequestBody.create((MediaType)contentType, (String)bodyStr);
                Request request2 = request.newBuilder().method(method, newBody).build();
                Intrinsics.checkNotNullExpressionValue((Object)request2, (String)"request.newBuilder()\n   \u2026                 .build()");
                newRequest = request2;
            }
            catch (Exception e) {
                Loger.eTag(tag, "\u8bfb\u53d6\u8bf7\u6c42\u4f53\u5931\u8d25: " + e.getMessage());
                bodyStr = "\u8bfb\u53d6\u5931\u8d25";
            }
        }
        CharSequence charSequence = headersStr;
        boolean bl = false;
        String headersInfo = charSequence.length() > 0 ? ", Headers: {" + headersStr + '}' : "";
        Loger.iTag(tag, "Request: URL: " + url + ", Method: " + method + headersInfo + ", Request Body: " + bodyStr);
        return newRequest;
    }

    static /* synthetic */ Request logRequest$default(HttpManager httpManager, Request request, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "CallSDK-HttpManager";
        }
        return httpManager.logRequest(request, string);
    }

    private final void logResponse(Response response2, String responseBody, String tag) {
        String string = responseBody;
        if (string == null) {
            string = "null";
        }
        String responseBodyStr = string;
        int statusCode = response2.code();
        String statusMessage = response2.message();
        Loger.iTag(tag, "Response: URL: " + response2.request().url() + ", Status Code: " + statusCode + ", Status Message: " + statusMessage + ", Response Body: " + responseBodyStr);
    }

    static /* synthetic */ void logResponse$default(HttpManager httpManager, Response response2, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "CallSDK-HttpManager";
        }
        httpManager.logResponse(response2, string, string2);
    }

    private final void executeRequest(Request request, OnResponseListener listener) {
        Request loggedRequest = HttpManager.logRequest$default(this, request, null, 2, null);
        this.client.newCall(loggedRequest).enqueue(new Callback(this, listener){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Loger.eTag("HttpManager", "\u8bf7\u6c42\u5931\u8d25: " + e.getMessage());
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                ResponseBody responseBody = response2.body();
                String responseBody2 = responseBody != null ? responseBody.string() : null;
                HttpManager.logResponse$default(this.this$0, response2, responseBody2, null, 4, null);
                if (response2.isSuccessful() && responseBody2 != null) {
                    if (HttpParser.INSTANCE.getSuccess(responseBody2)) {
                        this.$listener.onSuccess(responseBody2);
                    } else {
                        String errorMsg = HttpParser.INSTANCE.getMessage(responseBody2);
                        this.$listener.onFailed(errorMsg);
                    }
                } else {
                    this.$listener.onFailed("\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    private final RequestBody createJsonBody(JSONObject json) {
        RequestBody requestBody = RequestBody.create((MediaType)this.getJsonMediaType(), (String)json.toString());
        Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"RequestBody.create(jsonMediaType, json.toString())");
        return requestBody;
    }

    public final void login(@NotNull String username, @Nullable String password, @Nullable String passwordPk, @NotNull LoginListener listener) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.getCloudConfig(username, new OnResponseListener(this, username, password, passwordPk, listener){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ String $username;
            final /* synthetic */ String $password;
            final /* synthetic */ String $passwordPk;
            final /* synthetic */ LoginListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                HttpManager.access$loginInner(this.this$0, this.$username, this.$password, this.$passwordPk, this.$listener);
            }

            public void onFailed(@Nullable String failStr) {
                String string = failStr;
                if (string == null) {
                    string = "\u83b7\u53d6\u4e91\u914d\u7f6e\u5931\u8d25";
                }
                this.$listener.onFailed(-9999, string);
            }
            {
                this.this$0 = this$0;
                this.$username = $captured_local_variable$1;
                this.$password = $captured_local_variable$2;
                this.$passwordPk = $captured_local_variable$3;
                this.$listener = $captured_local_variable$4;
            }
        });
    }

    private final void getCloudConfig(String username, OnResponseListener listener) {
        String string;
        if (StringsKt.contains$default((CharSequence)username, (CharSequence)"@", (boolean)false, (int)2, null)) {
            String string2 = username;
            int n = StringsKt.indexOf$default((CharSequence)username, (String)"@", (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = username;
        }
        String accountName = string;
        String url = this.baseUrl + "/api/platform/public/cloudConfig?accountName=" + accountName;
        Request request = this.buildGetRequestWithoutAuth(url);
        Request loggedRequest = this.logRequest(request, "getCloudConfig");
        this.client.newCall(loggedRequest).enqueue(new Callback(this, listener){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Loger.eTag("HttpManager", "getCloudConfig failed: " + e.getMessage());
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                ResponseBody responseBody = response2.body();
                String responseBody2 = responseBody != null ? responseBody.string() : null;
                HttpManager.access$logResponse(this.this$0, response2, responseBody2, "getCloudConfig");
                if (response2.isSuccessful() && responseBody2 != null) {
                    if (HttpParser.INSTANCE.getSuccess(responseBody2)) {
                        try {
                            String baseURL;
                            String data = HttpParser.INSTANCE.getData(responseBody2);
                            JSONObject jsonObject = new JSONObject(data);
                            String server = jsonObject.optString("server", "");
                            String string = baseURL = jsonObject.optString("baseURL", "");
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"baseURL");
                            CharSequence charSequence = string;
                            boolean bl = false;
                            if (charSequence.length() > 0) {
                                if (!StringsKt.contains$default((CharSequence)baseURL, (CharSequence)"https://", (boolean)false, (int)2, null)) {
                                    baseURL = "https://" + baseURL;
                                }
                                String string2 = baseURL;
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"baseURL");
                                HttpManager.access$setBaseUrl$p(this.this$0, string2);
                                Loger.iTag("HttpManager", "Updated baseUrl: " + HttpManager.access$getBaseUrl$p(this.this$0));
                            }
                            this.$listener.onSuccess(data);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            this.$listener.onFailed("getCloudConfig failed: " + e.getMessage());
                        }
                    } else {
                        this.$listener.onFailed("getCloudConfig failed: " + HttpParser.INSTANCE.getMessage(responseBody2));
                    }
                } else {
                    this.$listener.onFailed("getCloudConfig failed: " + response2.code());
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    private final void performLogin(String username, String password, LoginListener listener) {
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("loginName", (Object)username);
        $this$apply.put("clientType", 2);
        $this$apply.put("password", (Object)password);
        $this$apply.put("loginDevice", (Object)DeviceUtils.INSTANCE.getLoginDevice());
        JSONObject loginJson = jSONObject;
        RequestBody requestBody = this.createJsonBody(loginJson);
        Request loginRequest = this.buildPostRequestWithoutAuth(this.baseUrl + "/api/platform/public/login", requestBody);
        Request loggedRequest = this.logRequest(loginRequest, "performLogin");
        this.client.newCall(loggedRequest).enqueue(new Callback(this, listener){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ LoginListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Loger.eTag("HttpManager", "performLogin failed: " + e.getMessage());
                String string = e.getMessage();
                if (string == null) {
                    string = "\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25";
                }
                this.$listener.onFailed(-9999, string);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                ResponseBody responseBody = response2.body();
                String loginResponseBody = responseBody != null ? responseBody.string() : null;
                HttpManager.access$logResponse(this.this$0, response2, loginResponseBody, "performLogin");
                if (response2.isSuccessful() && loginResponseBody != null) {
                    if (HttpParser.INSTANCE.getSuccess(loginResponseBody)) {
                        try {
                            String loginData = HttpParser.INSTANCE.getData(loginResponseBody);
                            Loger.iTag("HttpManager", "login data: " + loginData);
                            JSONObject loginDataObj = new JSONObject(loginData);
                            String accountId = loginDataObj.optString("accountId", "");
                            String sessionId = loginDataObj.optString("sessionId", "");
                            String loginToken = loginDataObj.optString("loginToken", "");
                            int clientType = loginDataObj.optInt("clientType", 2);
                            String string = loginToken;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loginToken");
                            SPUtils.put("loginToken", string);
                            String string2 = sessionId;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sessionId");
                            SPUtils.put("sessionId", string2);
                            SPUtils.put("clientType", clientType);
                            String string3 = accountId;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"accountId");
                            SPUtils.put("accountId", string3);
                            this.this$0.getLoginInfo(new OnResponseListener(this){
                                final /* synthetic */ performLogin.1 this$0;

                                public void onSuccess(@Nullable String responseStr) {
                                    this.this$0.$listener.onSuccess();
                                }

                                public void onFailed(@Nullable String failStr) {
                                    this.this$0.$listener.onSuccess();
                                }
                                {
                                    this.this$0 = this$0;
                                }
                            });
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            this.$listener.onFailed(-9999, "\u89e3\u6790\u767b\u5f55\u54cd\u5e94\u5931\u8d25");
                        }
                    } else {
                        try {
                            JSONObject jsonObject = new JSONObject(loginResponseBody);
                            String serverCode = jsonObject.optString("code", "");
                            String errorMsg = jsonObject.optString("message", "");
                            int errorCode = ErrorCode.INSTANCE.convertErrorCode(serverCode);
                            Loger.iTag("HttpManager", "Login failed, serverCode: " + serverCode + ", errorCode: " + errorCode + ", errorMsg: " + errorMsg);
                            this.$listener.onFailed(errorCode, errorMsg);
                        }
                        catch (Exception e) {
                            Loger.eTag("HttpManager", "Failed to parse error code: " + e.getMessage());
                            this.$listener.onFailed(-9999, "\u767b\u5f55\u5931\u8d25");
                        }
                    }
                } else {
                    this.$listener.onFailed(-9999, "\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    private final void loginInner(String username, String password, String passwordPk, LoginListener listener) {
        CharSequence charSequence = passwordPk;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Loger.iTag("HttpManager", "\u4f7f\u7528\u63d0\u4f9b\u7684\u516c\u94a5\uff0c\u8df3\u8fc7\u83b7\u53d6\u516c\u94a5\u6b65\u9aa4");
            this.performLogin(username, passwordPk, listener);
            return;
        }
        String url = this.baseUrl + "/api/platform/public/loginPre";
        Request request = this.buildGetRequestWithoutAuth(url);
        Request loggedRequest = this.logRequest(request, "loginInner");
        this.client.newCall(loggedRequest).enqueue(new Callback(this, listener, password, username){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ LoginListener $listener;
            final /* synthetic */ String $password;
            final /* synthetic */ String $username;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Loger.eTag("HttpManager", "loginInner failed: " + e.getMessage());
                this.$listener.onFailed(-9999, "\u83b7\u53d6\u516c\u94a5\u5931\u8d25: " + e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                ResponseBody responseBody = response2.body();
                String responseBody2 = responseBody != null ? responseBody.string() : null;
                HttpManager.access$logResponse(this.this$0, response2, responseBody2, "loginInner");
                if (response2.isSuccessful() && responseBody2 != null) {
                    if (HttpParser.INSTANCE.getSuccess(responseBody2)) {
                        try {
                            String pk;
                            String data = HttpParser.INSTANCE.getData(responseBody2);
                            JSONObject jsonObject = new JSONObject(data);
                            String string = pk = jsonObject.optString("pk", "");
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pk");
                            CharSequence charSequence = string;
                            boolean bl = false;
                            if (charSequence.length() == 0) {
                                this.$listener.onFailed(-9999, "\u83b7\u53d6\u516c\u94a5\u5931\u8d25");
                                return;
                            }
                            String encryptedPassword = LoginHelper.INSTANCE.parsePassword(pk, String.valueOf(this.$password));
                            HttpManager.access$performLogin(this.this$0, this.$username, encryptedPassword, this.$listener);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            this.$listener.onFailed(-9999, "\u89e3\u6790\u516c\u94a5\u54cd\u5e94\u5931\u8d25");
                        }
                    } else {
                        this.$listener.onFailed(-9999, "\u83b7\u53d6\u516c\u94a5\u5931\u8d25");
                    }
                } else {
                    this.$listener.onFailed(-9999, "\u83b7\u53d6\u516c\u94a5\u5931\u8d25: " + response2.code());
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
                this.$password = $captured_local_variable$2;
                this.$username = $captured_local_variable$3;
            }
        });
    }

    public final void unregisterDeviceToken(@NotNull String token, @NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("deviceToken", (Object)token);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/platform/action/apppush/remove", requestBody);
        this.executeRequest(request, listener);
    }

    public final void dialOutInfo(@NotNull String phoneNum, @NotNull String agentId, @NotNull String agentNumber, @NotNull String accountId, @NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)phoneNum, (String)"phoneNum");
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)agentNumber, (String)"agentNumber");
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("loginType", (Object)"PSTN");
        $this$apply.put("customerNumber", (Object)phoneNum);
        $this$apply.put("agentId", (Object)agentId);
        $this$apply.put("agentNumber", (Object)agentNumber);
        $this$apply.put("accountId", (Object)accountId);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/call/api/call/call/out", requestBody);
        Request loggedRequest = this.logRequest(request, "dialOutInfo");
        this.client.newCall(loggedRequest).enqueue(new Callback(this, listener){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Loger.eTag("HttpManager", "dialOutInfo failed: " + e.getMessage());
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ResponseBody responseBody = response2.body();
                    String responseBody2 = responseBody != null ? responseBody.string() : null;
                    HttpManager.access$logResponse(this.this$0, response2, responseBody2, "dialOutInfo");
                    if (response2.isSuccessful() && responseBody2 != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(responseBody2);
                            if (jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false)) {
                                this.$listener.onSuccess(responseBody2);
                                break block5;
                            }
                            String errorMsg = jsonObject.optString("message", jsonObject.optString("Message", "\u62e8\u53f7\u5931\u8d25"));
                            this.$listener.onFailed(errorMsg);
                        }
                        catch (Exception e) {
                            this.$listener.onFailed("\u89e3\u6790\u54cd\u5e94\u5931\u8d25: " + e.getMessage());
                        }
                    } else {
                        this.$listener.onFailed("\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    public final void getWebRtcInfo(@NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Request request = this.buildGetRequest(this.baseUrl + "/api/call/api/sip/webrtc/config/query/");
        Request loggedRequest = this.logRequest(request, "getWebRtcInfo");
        this.client.newCall(loggedRequest).enqueue(new Callback(this, listener){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Loger.eTag("HttpManager", "getWebRtcInfo failed: " + e.getMessage());
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ResponseBody responseBody = response2.body();
                    String responseBody2 = responseBody != null ? responseBody.string() : null;
                    HttpManager.access$logResponse(this.this$0, response2, responseBody2, "getWebRtcInfo");
                    if (response2.isSuccessful() && responseBody2 != null) {
                        try {
                            boolean bl;
                            CharSequence charSequence;
                            JSONObject jsonObject = new JSONObject(responseBody2);
                            String dataStr = null;
                            if (jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false)) {
                                String string = dataStr = jsonObject.optString("data", "");
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataStr");
                                charSequence = string;
                                bl = false;
                                if (charSequence.length() == 0 && jsonObject.has("registerUrl")) {
                                    dataStr = responseBody2;
                                }
                            } else if (jsonObject.has("registerUrl") || jsonObject.has("sip")) {
                                dataStr = responseBody2;
                            }
                            if (dataStr != null) {
                                charSequence = dataStr;
                                bl = false;
                                if (charSequence.length() > 0) {
                                    SPUtils.put("webRtcSipInfo", dataStr);
                                    this.$listener.onSuccess(responseBody2);
                                    break block10;
                                }
                            }
                            String errorMsg = jsonObject.optString("message", jsonObject.optString("Message", "\u83b7\u53d6 WebRTC \u914d\u7f6e\u5931\u8d25"));
                            this.$listener.onFailed(errorMsg);
                        }
                        catch (Exception e) {
                            this.$listener.onFailed("\u89e3\u6790\u54cd\u5e94\u5931\u8d25: " + e.getMessage());
                        }
                    } else {
                        this.$listener.onFailed("\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    public final void getLoginInfo(@NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Request request = this.buildGetRequest(this.baseUrl + "/api/platform/action/loginInfo");
        Request loggedRequest = this.logRequest(request, "getLoginInfo");
        this.client.newCall(loggedRequest).enqueue(new Callback(this, listener){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Loger.eTag("HttpManager", "getLoginInfo failed: " + e.getMessage());
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ResponseBody responseBody = response2.body();
                    String responseBody2 = responseBody != null ? responseBody.string() : null;
                    HttpManager.access$logResponse(this.this$0, response2, responseBody2, "getLoginInfo");
                    if (response2.isSuccessful() && responseBody2 != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(responseBody2);
                            if (jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false)) {
                                String dataStr;
                                String string = dataStr = jsonObject.optString("data", "");
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataStr");
                                CharSequence charSequence = string;
                                boolean bl = false;
                                if (charSequence.length() > 0) {
                                    try {
                                        JSONObject dataObj = new JSONObject(dataStr);
                                        JSONArray pushServerArray = dataObj.optJSONArray("pushServer");
                                        if (pushServerArray != null && pushServerArray.length() > 0) {
                                            String wsUrl;
                                            JSONObject pushServerObj = pushServerArray.getJSONObject(0);
                                            String string2 = wsUrl = pushServerObj.optString("url", "");
                                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"wsUrl");
                                            CharSequence charSequence2 = string2;
                                            boolean bl2 = false;
                                            if (charSequence2.length() > 0) {
                                                SPUtils.put("WS_HOST", wsUrl);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                this.$listener.onSuccess(responseBody2);
                                break block10;
                            }
                            String errorMsg = jsonObject.optString("message", jsonObject.optString("Message", "\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25"));
                            this.$listener.onFailed(errorMsg);
                        }
                        catch (Exception e) {
                            this.$listener.onFailed("\u89e3\u6790\u54cd\u5e94\u5931\u8d25: " + e.getMessage());
                        }
                    } else {
                        this.$listener.onFailed("\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    public final void getWsToken(@NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Request request = this.buildGetRequest(this.baseUrl + "/api/platform/action/refreshWsToken/");
        Request loggedRequest = this.logRequest(request, "getWsToken");
        this.client.newCall(loggedRequest).enqueue(new Callback(this, listener){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Loger.eTag("HttpManager", "getWsToken failed: " + e.getMessage());
                this.$listener.onFailed(e.getMessage());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ResponseBody responseBody = response2.body();
                    String responseBody2 = responseBody != null ? responseBody.string() : null;
                    HttpManager.access$logResponse(this.this$0, response2, responseBody2, "getWsToken");
                    if (response2.isSuccessful() && responseBody2 != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(responseBody2);
                            if (jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false)) {
                                String dataStr;
                                String string = dataStr = jsonObject.optString("data", "");
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataStr");
                                CharSequence charSequence = string;
                                boolean bl = false;
                                if (charSequence.length() > 0) {
                                    JSONObject dataObj = new JSONObject(dataStr);
                                    String wsToken = dataObj.optString("wsToken", "");
                                    String timestamp = dataObj.optString("timestamp", "");
                                    String string2 = wsToken;
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"wsToken");
                                    CharSequence charSequence2 = string2;
                                    boolean bl2 = false;
                                    if (charSequence2.length() > 0) {
                                        String string3 = timestamp;
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"timestamp");
                                        charSequence2 = string3;
                                        bl2 = false;
                                        if (charSequence2.length() > 0) {
                                            SPUtils.put("wsToken", wsToken);
                                            SPUtils.put("timestamp", timestamp);
                                        }
                                    }
                                }
                                this.$listener.onSuccess(responseBody2);
                                break block8;
                            }
                            String errorMsg = jsonObject.optString("message", jsonObject.optString("Message", "\u83b7\u53d6 WebSocket Token \u5931\u8d25"));
                            this.$listener.onFailed(errorMsg);
                        }
                        catch (Exception e) {
                            this.$listener.onFailed("\u89e3\u6790\u54cd\u5e94\u5931\u8d25: " + e.getMessage());
                        }
                    } else {
                        this.$listener.onFailed("\u8bf7\u6c42\u5931\u8d25: " + response2.code());
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    public final void riskQuery(@NotNull String phoneNum, @NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)phoneNum, (String)"phoneNum");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("number", (Object)phoneNum);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/call/api/risk/query", requestBody);
        Request loggedRequest = this.logRequest(request, "riskQuery");
        this.client.newCall(loggedRequest).enqueue(new Callback(this, listener){
            final /* synthetic */ HttpManager this$0;
            final /* synthetic */ OnResponseListener $listener;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Loger.eTag("HttpManager", "riskQuery failed: " + e.getMessage());
                this.$listener.onSuccess("\u98ce\u9669\u67e5\u8be2\u5931\u8d25\uff0c\u4f46\u5141\u8bb8\u7ee7\u7eed\u62e8\u6253");
            }

            public void onResponse(@NotNull Call call, @NotNull Response response2) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    ResponseBody responseBody = response2.body();
                    String responseBody2 = responseBody != null ? responseBody.string() : null;
                    HttpManager.access$logResponse(this.this$0, response2, responseBody2, "riskQuery");
                    if (response2.isSuccessful() && responseBody2 != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(responseBody2);
                            boolean success = jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false);
                            String code = jsonObject.optString("code", "");
                            if (success && Intrinsics.areEqual((Object)code, (Object)"200")) {
                                this.$listener.onSuccess(responseBody2);
                                break block5;
                            }
                            String errorMsg = jsonObject.optString("message", jsonObject.optString("Message", "\u98ce\u9669\u67e5\u8be2\u5931\u8d25"));
                            this.$listener.onFailed(errorMsg);
                        }
                        catch (Exception e) {
                            this.$listener.onSuccess("\u98ce\u9669\u67e5\u8be2\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u5141\u8bb8\u7ee7\u7eed\u62e8\u6253");
                        }
                    } else {
                        this.$listener.onSuccess("\u98ce\u9669\u67e5\u8be2\u5931\u8d25\uff0c\u4f46\u5141\u8bb8\u7ee7\u7eed\u62e8\u6253");
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    public final void queryNumberGroupList(int page, int pageSize, @NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        $this$apply.put("page", page);
        $this$apply.put("pageSize", pageSize);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/call/web/call/action/config/number/group/v1/query", requestBody);
        this.executeRequest(request, listener);
    }

    public static /* synthetic */ void queryNumberGroupList$default(HttpManager httpManager, int n, int n2, OnResponseListener onResponseListener, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = 999;
        }
        httpManager.queryNumberGroupList(n, n2, onResponseListener);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateAgentNumberGroup(@NotNull String agentId, @NotNull String numberGroupId, @NotNull OnResponseListener listener) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)numberGroupId, (String)"numberGroupId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply2 = jSONObject;
        boolean bl3 = false;
        $this$apply2.put("_id", (Object)agentId);
        JSONObject jSONObject2 = new JSONObject();
        boolean bl4 = false;
        boolean bl5 = false;
        JSONObject jSONObject3 = jSONObject2;
        String string = "agentCallConfig";
        JSONObject jSONObject4 = $this$apply2;
        boolean bl6 = false;
        $this$apply.put("numberGroup", (Object)numberGroupId);
        Unit unit = Unit.INSTANCE;
        jSONObject4.put(string, (Object)jSONObject2);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/platform/action/agent/update", requestBody);
        this.executeRequest(request, listener);
    }

    public final void queryDisplayNumberList(@NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String url = this.baseUrl + "/api/call/web/config/number/display/cache";
        Request request = this.buildGetRequest(url);
        this.executeRequest(request, listener);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateAgentSelectNumber(@NotNull String agentId, @NotNull String selectNumber, @NotNull OnResponseListener listener) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)selectNumber, (String)"selectNumber");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply2 = jSONObject;
        boolean bl3 = false;
        $this$apply2.put("_id", (Object)agentId);
        JSONObject jSONObject2 = new JSONObject();
        boolean bl4 = false;
        boolean bl5 = false;
        JSONObject jSONObject3 = jSONObject2;
        String string = "agentCallConfig";
        JSONObject jSONObject4 = $this$apply2;
        boolean bl6 = false;
        $this$apply.put("selectNumber", (Object)selectNumber);
        Unit unit = Unit.INSTANCE;
        jSONObject4.put(string, (Object)jSONObject2);
        JSONObject json = jSONObject;
        RequestBody requestBody = this.createJsonBody(json);
        Request request = this.buildPostRequest(this.baseUrl + "/api/platform/action/agent/update", requestBody);
        this.executeRequest(request, listener);
    }

    public final void getFullAgent(@NotNull String agentId, @NotNull OnResponseListener listener) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String url = this.baseUrl + "/api/platform/action/agent/getFullAgent?agentId=" + agentId;
        Request request = this.buildGetRequest(url);
        this.executeRequest(request, listener);
    }

    private HttpManager() {
        SDKConfig config = CallSDK.getConfig();
        this.baseUrl = config.getBaseUrl();
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"OkHttpClient.Builder()\n \u2026NDS)\n            .build()");
        this.client = okHttpClient;
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$loginInner(HttpManager $this, String username, String password, String passwordPk, LoginListener listener) {
        $this.loginInner(username, password, passwordPk, listener);
    }

    public static final /* synthetic */ void access$logResponse(HttpManager $this, Response response2, String responseBody, String tag) {
        $this.logResponse(response2, responseBody, tag);
    }

    public static final /* synthetic */ String access$getBaseUrl$p(HttpManager $this) {
        return $this.baseUrl;
    }

    public static final /* synthetic */ void access$setBaseUrl$p(HttpManager $this, String string) {
        $this.baseUrl = string;
    }

    public static final /* synthetic */ void access$performLogin(HttpManager $this, String username, String password, LoginListener listener) {
        $this.performLogin(username, password, listener);
    }

    public /* synthetic */ HttpManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/useasy/callsdk/http/HttpManager$Companion;", "", "()V", "instance", "Lcom/useasy/callsdk/http/HttpManager;", "getInstance", "callsdk_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final HttpManager getInstance() {
            HttpManager httpManager = instance;
            if (httpManager == null) {
                boolean bl = false;
                boolean bl2 = false;
                synchronized (this) {
                    boolean bl3 = false;
                    HttpManager httpManager2 = instance;
                    if (httpManager2 == null) {
                        HttpManager httpManager3 = new HttpManager(null);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        HttpManager it = httpManager3;
                        boolean bl6 = false;
                        instance = it;
                        httpManager2 = httpManager3;
                    }
                    HttpManager httpManager4 = httpManager2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl19 : MonitorExitStatement: MONITOREXIT : this
                    httpManager = httpManager4;
                }
            }
            return httpManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

