/*
 * Decompiled with CFR 0.152.
 */
package com.useasy.callsdk;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import com.useasy.callsdk.CallSDK;
import com.useasy.callsdk.bean.AgentBean;
import com.useasy.callsdk.bean.AgentConfig;
import com.useasy.callsdk.bean.DisplayNumber;
import com.useasy.callsdk.bean.LoginInfo;
import com.useasy.callsdk.bean.NumberGroupListResponse;
import com.useasy.callsdk.bean.SipParams;
import com.useasy.callsdk.config.SDKConfig;
import com.useasy.callsdk.constant.ErrorCode;
import com.useasy.callsdk.http.HttpManager;
import com.useasy.callsdk.listener.AgentConfigListener;
import com.useasy.callsdk.listener.CallStateListener;
import com.useasy.callsdk.listener.DisplayNumberListListener;
import com.useasy.callsdk.listener.InitListener;
import com.useasy.callsdk.listener.LoginListener;
import com.useasy.callsdk.listener.NumberGroupListListener;
import com.useasy.callsdk.listener.OnResponseListener;
import com.useasy.callsdk.listener.SocketMessageListener;
import com.useasy.callsdk.manager.CallManager;
import com.useasy.callsdk.manager.LoginManager;
import com.useasy.callsdk.manager.SocketManager;
import com.useasy.callsdk.utils.AudioUtils;
import com.useasy.callsdk.utils.Loger;
import com.useasy.callsdk.utils.ResponseParser;
import com.useasy.callsdk.utils.SPUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u000eH\u0007J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0003J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0007J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\b\u0010\u0019\u001a\u00020\nH\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0007J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0007J\b\u0010\u001f\u001a\u00020\nH\u0007J\b\u0010 \u001a\u00020\nH\u0007J\b\u0010!\u001a\u00020\u0010H\u0007J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020$H\u0007J\"\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0012\u001a\u00020$H\u0007J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\nH\u0007J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\nH\u0007J&\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010#\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010-\u001a\u00020\u00102\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100/H\u0002J\u0010\u00100\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u000201H\u0007J$\u00102\u001a\u00020\u00102\b\b\u0002\u00103\u001a\u00020\u001b2\b\b\u0002\u00104\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u000205H\u0007J\u0010\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u00020\u0006H\u0007J\u001a\u00106\u001a\u00020\u001b2\b\u00108\u001a\u0004\u0018\u00010\u00062\u0006\u00109\u001a\u00020:H\u0003J\u0017\u0010;\u001a\u00020\u00102\b\u00108\u001a\u0004\u0018\u00010\u0006H\u0001\u00a2\u0006\u0002\b<J\u0018\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010?\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/useasy/callsdk/CallSDK;", "", "()V", "applicationContext", "Landroid/content/Context;", "currentCallId", "", "initListener", "Lcom/useasy/callsdk/listener/InitListener;", "isInitialized", "", "mainHandler", "Landroid/os/Handler;", "sdkConfig", "Lcom/useasy/callsdk/config/SDKConfig;", "checkInitialized", "", "getAgentConfig", "listener", "Lcom/useasy/callsdk/listener/AgentConfigListener;", "getConfig", "getCurrentCall", "getCurrentCallId", "getLoginInfo", "Lcom/useasy/callsdk/bean/LoginInfo;", "getMuteStatus", "hangupCall", "", "init", "context", "config", "isLoudSpeakerOn", "isMuteOn", "logout", "makeCall", "phoneNumber", "Lcom/useasy/callsdk/listener/CallStateListener;", "userData", "Lorg/json/JSONObject;", "openLoudSpeaker", "open", "openMute", "parseSipParamsFromWebRtcInfo", "Lcom/useasy/callsdk/bean/SipParams;", "responseStr", "postToMain", "block", "Lkotlin/Function0;", "queryDisplayNumberList", "Lcom/useasy/callsdk/listener/DisplayNumberListListener;", "queryNumberGroupList", "page", "pageSize", "Lcom/useasy/callsdk/listener/NumberGroupListListener;", "sendDTMF", "dtmfNumber", "callId", "dtmf", "", "setCurrentCallId", "setCurrentCallId$callsdk_release", "updateAgentNumberGroup", "numberGroupId", "updateAgentSelectNumber", "selectNumber", "callsdk_release"})
public final class CallSDK {
    private static boolean isInitialized;
    private static SDKConfig sdkConfig;
    private static InitListener initListener;
    private static String currentCallId;
    private static Context applicationContext;
    private static final Handler mainHandler;
    @NotNull
    public static final CallSDK INSTANCE;

    private final void postToMain(Function0<Unit> block) {
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            block.invoke();
        } else {
            mainHandler.post(new Runnable(block){
                final /* synthetic */ Function0 $block;

                public final void run() {
                    this.$block.invoke();
                }
                {
                    this.$block = function0;
                }
            });
        }
    }

    @JvmStatic
    public static final void init(@NotNull Context context, @NotNull SDKConfig config, @NotNull InitListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        sdkConfig = config;
        initListener = listener;
        applicationContext = context.getApplicationContext();
        isInitialized = true;
        SPUtils.init(context);
        File logDir = config.getLogConfig().getLogFilePath() != null ? new File(config.getLogConfig().getLogFilePath()) : new File(context.getFilesDir(), "logs");
        Loger.getConfig().setLogSwitch(config.getLogConfig().getEnableLog()).setConsoleSwitch(config.getLogConfig().getConsoleLogEnabled()).setLog2FileSwitch(config.getLogConfig().getFileLoggingEnabled()).setDir(logDir).setFilePrefix("callsdk").setConsoleFilter(config.getLogConfig().getLogLevel()).setFileFilter(config.getLogConfig().getLogLevel());
        Loger.iTag("CallSDK", "SDK initialized, enableLog: " + config.getLogConfig().getEnableLog() + ", logLevel: " + config.getLogConfig().getLogLevel() + ", fileLoggingEnabled: " + config.getLogConfig().getFileLoggingEnabled() + ", consoleLogEnabled: " + config.getLogConfig().getConsoleLogEnabled());
        SocketManager.INSTANCE.setMessageListener$callsdk_release(new SocketMessageListener(){

            public void onKicked() {
                Loger.iTag("CallSDK", "Kicked");
                CallSDK.access$postToMain(CallSDK.INSTANCE, init.onKicked.1.INSTANCE);
            }

            public void onMessage(@NotNull String messageType, @Nullable String messageData) {
                Intrinsics.checkNotNullParameter((Object)messageType, (String)"messageType");
                SocketMessageListener.DefaultImpls.onMessage(this, messageType, messageData);
            }

            public void onSocketConnectFailed(@Nullable String error) {
                SocketMessageListener.DefaultImpls.onSocketConnectFailed(this, error);
            }

            public void onSocketConnected() {
                SocketMessageListener.DefaultImpls.onSocketConnected(this);
            }

            public void onSocketDisconnected() {
                SocketMessageListener.DefaultImpls.onSocketDisconnected(this);
            }
        });
        LoginManager.INSTANCE.login$callsdk_release(config.getUsername(), config.getPassword(), config.getPasswordPk(), new LoginListener(){

            public void onSuccess() {
                Loger.iTag("CallSDK", "init success");
                CallSDK.access$postToMain(CallSDK.INSTANCE, init.onSuccess.1.INSTANCE);
            }

            public void onFailed(int errorCode, @Nullable String errorMsg) {
                Loger.iTag("CallSDK", "Login failed, errorCode: " + errorCode + ", errorMsg: " + errorMsg);
                CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(errorCode, errorMsg){
                    final /* synthetic */ int $errorCode;
                    final /* synthetic */ String $errorMsg;

                    public final void invoke() {
                        block0: {
                            InitListener initListener = CallSDK.access$getInitListener$p(CallSDK.INSTANCE);
                            if (initListener == null) break block0;
                            initListener.onInitFailed(this.$errorCode, this.$errorMsg);
                        }
                    }
                    {
                        this.$errorCode = n;
                        this.$errorMsg = string;
                        super(0);
                    }
                });
            }
        });
        CallManager.INSTANCE.init$callsdk_release();
    }

    @JvmStatic
    public static final void logout() {
        INSTANCE.checkInitialized();
        Context context = applicationContext;
        Intrinsics.checkNotNull((Object)context);
        CallManager.INSTANCE.unInitializeCall$callsdk_release(context);
        LoginManager.INSTANCE.logout$callsdk_release();
    }

    @JvmStatic
    @Nullable
    public static final LoginInfo getLoginInfo() {
        INSTANCE.checkInitialized();
        return LoginManager.INSTANCE.getLoginInfo$callsdk_release();
    }

    @JvmStatic
    public static final void queryNumberGroupList(int page, int pageSize, @NotNull NumberGroupListListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        HttpManager.Companion.getInstance().queryNumberGroupList(page, pageSize, new OnResponseListener(listener){
            final /* synthetic */ NumberGroupListListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                try {
                    NumberGroupListResponse parsed = ResponseParser.INSTANCE.parseNumberGroupListResponse(responseStr);
                    CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, parsed){
                        final /* synthetic */ queryNumberGroupList.1 this$0;
                        final /* synthetic */ NumberGroupListResponse $parsed;

                        public final void invoke() {
                            this.this$0.$listener.onSuccess(this.$parsed);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$parsed = numberGroupListResponse;
                            super(0);
                        }
                    });
                }
                catch (Exception e) {
                    CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, e){
                        final /* synthetic */ queryNumberGroupList.1 this$0;
                        final /* synthetic */ Exception $e;

                        public final void invoke() {
                            this.this$0.$listener.onFailed("\u89e3\u6790\u5931\u8d25: " + this.$e.getMessage());
                        }
                        {
                            this.this$0 = var1_1;
                            this.$e = exception;
                            super(0);
                        }
                    });
                }
            }

            public void onFailed(@Nullable String failStr) {
                CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, failStr){
                    final /* synthetic */ queryNumberGroupList.1 this$0;
                    final /* synthetic */ String $failStr;

                    public final void invoke() {
                        this.this$0.$listener.onFailed(this.$failStr);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$failStr = string;
                        super(0);
                    }
                });
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public static /* synthetic */ void queryNumberGroupList$default(int n, int n2, NumberGroupListListener numberGroupListListener, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = 999;
        }
        CallSDK.queryNumberGroupList(n, n2, numberGroupListListener);
    }

    @JvmStatic
    public static final void queryDisplayNumberList(@NotNull DisplayNumberListListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        HttpManager.Companion.getInstance().queryDisplayNumberList(new OnResponseListener(listener){
            final /* synthetic */ DisplayNumberListListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                try {
                    List<DisplayNumber> numbers = ResponseParser.INSTANCE.parseDisplayNumberListResponse(responseStr);
                    CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, numbers){
                        final /* synthetic */ queryDisplayNumberList.1 this$0;
                        final /* synthetic */ List $numbers;

                        public final void invoke() {
                            this.this$0.$listener.onSuccess(this.$numbers);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$numbers = list;
                            super(0);
                        }
                    });
                }
                catch (Exception e) {
                    CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, e){
                        final /* synthetic */ queryDisplayNumberList.1 this$0;
                        final /* synthetic */ Exception $e;

                        public final void invoke() {
                            this.this$0.$listener.onFailed("\u89e3\u6790\u5931\u8d25: " + this.$e.getMessage());
                        }
                        {
                            this.this$0 = var1_1;
                            this.$e = exception;
                            super(0);
                        }
                    });
                }
            }

            public void onFailed(@Nullable String failStr) {
                CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, failStr){
                    final /* synthetic */ queryDisplayNumberList.1 this$0;
                    final /* synthetic */ String $failStr;

                    public final void invoke() {
                        this.this$0.$listener.onFailed(this.$failStr);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$failStr = string;
                        super(0);
                    }
                });
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    @JvmStatic
    public static final void updateAgentNumberGroup(@NotNull String numberGroupId, @NotNull AgentConfigListener listener) {
        Intrinsics.checkNotNullParameter((Object)numberGroupId, (String)"numberGroupId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        LoginInfo loginInfo = CallSDK.getLoginInfo();
        Object object = loginInfo;
        String agentId = object != null && (object = ((LoginInfo)object).getAgent()) != null ? ((AgentBean)object).get_id() : null;
        HttpManager.Companion.getInstance().updateAgentNumberGroup(String.valueOf(agentId), numberGroupId, new OnResponseListener(listener){
            final /* synthetic */ AgentConfigListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                try {
                    AgentConfig config = ResponseParser.INSTANCE.parseAgentConfig(responseStr);
                    CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, config){
                        final /* synthetic */ updateAgentNumberGroup.1 this$0;
                        final /* synthetic */ AgentConfig $config;

                        public final void invoke() {
                            this.this$0.$listener.onSuccess(this.$config);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$config = agentConfig;
                            super(0);
                        }
                    });
                }
                catch (Exception e) {
                    CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, e){
                        final /* synthetic */ updateAgentNumberGroup.1 this$0;
                        final /* synthetic */ Exception $e;

                        public final void invoke() {
                            this.this$0.$listener.onFailed("\u89e3\u6790\u5931\u8d25: " + this.$e.getMessage());
                        }
                        {
                            this.this$0 = var1_1;
                            this.$e = exception;
                            super(0);
                        }
                    });
                }
            }

            public void onFailed(@Nullable String failStr) {
                CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, failStr){
                    final /* synthetic */ updateAgentNumberGroup.1 this$0;
                    final /* synthetic */ String $failStr;

                    public final void invoke() {
                        this.this$0.$listener.onFailed(this.$failStr);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$failStr = string;
                        super(0);
                    }
                });
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    @JvmStatic
    public static final void updateAgentSelectNumber(@NotNull String selectNumber, @NotNull AgentConfigListener listener) {
        Intrinsics.checkNotNullParameter((Object)selectNumber, (String)"selectNumber");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        LoginInfo loginInfo = CallSDK.getLoginInfo();
        Object object = loginInfo;
        String agentId = object != null && (object = ((LoginInfo)object).getAgent()) != null ? ((AgentBean)object).get_id() : null;
        HttpManager.Companion.getInstance().updateAgentSelectNumber(String.valueOf(agentId), selectNumber, new OnResponseListener(listener){
            final /* synthetic */ AgentConfigListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                try {
                    AgentConfig config = ResponseParser.INSTANCE.parseAgentConfig(responseStr);
                    CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, config){
                        final /* synthetic */ updateAgentSelectNumber.1 this$0;
                        final /* synthetic */ AgentConfig $config;

                        public final void invoke() {
                            this.this$0.$listener.onSuccess(this.$config);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$config = agentConfig;
                            super(0);
                        }
                    });
                }
                catch (Exception e) {
                    CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, e){
                        final /* synthetic */ updateAgentSelectNumber.1 this$0;
                        final /* synthetic */ Exception $e;

                        public final void invoke() {
                            this.this$0.$listener.onFailed("\u89e3\u6790\u5931\u8d25: " + this.$e.getMessage());
                        }
                        {
                            this.this$0 = var1_1;
                            this.$e = exception;
                            super(0);
                        }
                    });
                }
            }

            public void onFailed(@Nullable String failStr) {
                CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, failStr){
                    final /* synthetic */ updateAgentSelectNumber.1 this$0;
                    final /* synthetic */ String $failStr;

                    public final void invoke() {
                        this.this$0.$listener.onFailed(this.$failStr);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$failStr = string;
                        super(0);
                    }
                });
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    @JvmStatic
    public static final void getAgentConfig(@NotNull AgentConfigListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        LoginInfo loginInfo = CallSDK.getLoginInfo();
        Object object = loginInfo;
        String agentId = object != null && (object = ((LoginInfo)object).getAgent()) != null ? ((AgentBean)object).get_id() : null;
        HttpManager.Companion.getInstance().getFullAgent(String.valueOf(agentId), new OnResponseListener(listener){
            final /* synthetic */ AgentConfigListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                try {
                    AgentConfig config = ResponseParser.INSTANCE.parseAgentConfig(responseStr);
                    CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, config){
                        final /* synthetic */ getAgentConfig.1 this$0;
                        final /* synthetic */ AgentConfig $config;

                        public final void invoke() {
                            this.this$0.$listener.onSuccess(this.$config);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$config = agentConfig;
                            super(0);
                        }
                    });
                }
                catch (Exception e) {
                    CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, e){
                        final /* synthetic */ getAgentConfig.1 this$0;
                        final /* synthetic */ Exception $e;

                        public final void invoke() {
                            this.this$0.$listener.onFailed("\u89e3\u6790\u5931\u8d25: " + this.$e.getMessage());
                        }
                        {
                            this.this$0 = var1_1;
                            this.$e = exception;
                            super(0);
                        }
                    });
                }
            }

            public void onFailed(@Nullable String failStr) {
                CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, failStr){
                    final /* synthetic */ getAgentConfig.1 this$0;
                    final /* synthetic */ String $failStr;

                    public final void invoke() {
                        this.this$0.$listener.onFailed(this.$failStr);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$failStr = string;
                        super(0);
                    }
                });
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    private final void checkInitialized() {
        if (!isInitialized) {
            throw (Throwable)new IllegalStateException("CallSDK not initialized. Call CallSDK.init() first.");
        }
    }

    @JvmStatic
    @NotNull
    public static final SDKConfig getConfig() {
        INSTANCE.checkInitialized();
        SDKConfig sDKConfig = sdkConfig;
        Intrinsics.checkNotNull((Object)sDKConfig);
        return sDKConfig;
    }

    @JvmStatic
    public static final void setCurrentCallId$callsdk_release(@Nullable String callId) {
        INSTANCE.checkInitialized();
        currentCallId = callId;
        Loger.iTag("CallSDK", "Current call ID set to: " + callId);
    }

    @JvmStatic
    @Nullable
    public static final String getCurrentCallId() {
        INSTANCE.checkInitialized();
        String string = currentCallId;
        if (string == null) {
            string = CallSDK.getCurrentCall();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final int sendDTMF(@NotNull String dtmfNumber) {
        int n;
        String callId;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)dtmfNumber, (String)"dtmfNumber");
                INSTANCE.checkInitialized();
                CharSequence charSequence = dtmfNumber;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    Loger.wTag("CallSDK", "DTMF number is empty");
                    return -1;
                }
                callId = CallSDK.getCurrentCallId();
                if (callId == null) break block4;
                CharSequence charSequence2 = callId;
                n = 0;
                if (charSequence2.length() > 0) break block5;
            }
            Loger.wTag("CallSDK", "No active call to send DTMF");
            return -1;
        }
        char dtmfChar = dtmfNumber.charAt(0);
        int result = CallSDK.sendDTMF(callId, dtmfChar);
        Loger.iTag("CallSDK", "Send DTMF result: " + result + ", callId: " + callId + ", dtmf: " + dtmfChar);
        int n2 = n;
        return n2;
    }

    @JvmStatic
    public static final int openLoudSpeaker(boolean open) {
        INSTANCE.checkInitialized();
        Context context = applicationContext;
        Intrinsics.checkNotNull((Object)context);
        int result = CallManager.INSTANCE.enableLoudsSpeaker$callsdk_release(context, open);
        Loger.iTag("CallSDK", "Set loudspeaker result: " + result + ", open: " + open);
        return result;
    }

    @JvmStatic
    public static final boolean isLoudSpeakerOn() {
        INSTANCE.checkInitialized();
        Context context = applicationContext;
        Intrinsics.checkNotNull((Object)context);
        return CallManager.INSTANCE.getLoudsSpeakerStatus$callsdk_release(context);
    }

    @JvmStatic
    public static final int openMute(boolean open) {
        INSTANCE.checkInitialized();
        int result = CallManager.INSTANCE.setMute$callsdk_release(open);
        Loger.iTag("CallSDK", "Set mute result: " + result + ", open: " + open);
        return result;
    }

    @JvmStatic
    public static final boolean isMuteOn() {
        INSTANCE.checkInitialized();
        return CallSDK.getMuteStatus();
    }

    @JvmStatic
    public static final void makeCall(@NotNull String phoneNumber, @NotNull CallStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        CallSDK.makeCall(phoneNumber, null, listener);
    }

    @JvmStatic
    public static final void makeCall(@NotNull String phoneNumber, @Nullable JSONObject userData, @NotNull CallStateListener listener) {
        String string;
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        INSTANCE.checkInitialized();
        Context context = applicationContext;
        Intrinsics.checkNotNull((Object)context);
        Context context2 = context;
        AudioUtils.pauseMusic(context2);
        Object object = context2.getSystemService("audio");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
        }
        AudioManager audioManager = (AudioManager)object;
        audioManager.setMode(3);
        if (userData != null) {
            String string2;
            try {
                String jsonStr;
                String string3 = userData.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"userData.toString()");
                String string4 = jsonStr = string3;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string5.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] jsonBytes = byArray;
                if (jsonBytes.length > 255) {
                    Loger.eTag("CallSDK", "userData exceeds 255 bytes (" + jsonBytes.length + "), returning error");
                    int errorCode = -407;
                    String errorMsg = ErrorCode.INSTANCE.getErrorMessage(errorCode);
                    INSTANCE.postToMain((Function0<Unit>)((Function0)new Function0<Unit>(listener, errorCode, errorMsg){
                        final /* synthetic */ CallStateListener $listener;
                        final /* synthetic */ int $errorCode;
                        final /* synthetic */ String $errorMsg;

                        public final void invoke() {
                            this.$listener.onCallFailed(null, this.$errorCode, this.$errorMsg);
                        }
                        {
                            this.$listener = callStateListener;
                            this.$errorCode = n;
                            this.$errorMsg = string;
                            super(0);
                        }
                    }));
                }
                string2 = Base64.encodeToString((byte[])jsonBytes, (int)2);
            }
            catch (Exception e) {
                Loger.eTag("CallSDK", "Failed to convert userData to string: " + e.getMessage());
                int errorCode = -9999;
                String errorMsg = "userData \u8f6c\u6362\u5931\u8d25: " + e.getMessage();
                INSTANCE.postToMain((Function0<Unit>)((Function0)new Function0<Unit>(listener, errorCode, errorMsg){
                    final /* synthetic */ CallStateListener $listener;
                    final /* synthetic */ int $errorCode;
                    final /* synthetic */ String $errorMsg;

                    public final void invoke() {
                        this.$listener.onCallFailed(null, this.$errorCode, this.$errorMsg);
                    }
                    {
                        this.$listener = callStateListener;
                        this.$errorCode = n;
                        this.$errorMsg = string;
                        super(0);
                    }
                }));
                string2 = Unit.INSTANCE;
            }
            string = string2;
        } else {
            string = null;
        }
        String userDataStr2 = string;
        HttpManager.Companion.getInstance().getWebRtcInfo(new OnResponseListener(phoneNumber, userDataStr2, context2, listener){
            final /* synthetic */ String $phoneNumber;
            final /* synthetic */ Object $userDataStr;
            final /* synthetic */ Context $context;
            final /* synthetic */ CallStateListener $listener;

            public void onSuccess(@Nullable String responseStr) {
                SipParams sipParams = CallSDK.access$parseSipParamsFromWebRtcInfo(CallSDK.INSTANCE, responseStr, this.$phoneNumber, String.valueOf(this.$userDataStr));
                if (sipParams != null) {
                    int result = CallManager.INSTANCE.initCall$callsdk_release(this.$context, sipParams, this.$listener);
                    if (result != 0) {
                        int errorCode = -9999;
                        String errorMsg = ErrorCode.INSTANCE.getErrorMessage(errorCode);
                        CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, errorCode, errorMsg){
                            final /* synthetic */ makeCall.1 this$0;
                            final /* synthetic */ int $errorCode;
                            final /* synthetic */ String $errorMsg;

                            public final void invoke() {
                                this.this$0.$listener.onCallFailed(null, this.$errorCode, this.$errorMsg);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$errorCode = n;
                                this.$errorMsg = string;
                                super(0);
                            }
                        });
                    }
                } else {
                    int errorCode = -9999;
                    String errorMsg = "\u89e3\u6790 SIP \u53c2\u6570\u5931\u8d25";
                    CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, errorCode, errorMsg){
                        final /* synthetic */ makeCall.1 this$0;
                        final /* synthetic */ int $errorCode;
                        final /* synthetic */ String $errorMsg;

                        public final void invoke() {
                            this.this$0.$listener.onCallFailed(null, this.$errorCode, this.$errorMsg);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$errorCode = n;
                            this.$errorMsg = string;
                            super(0);
                        }
                    });
                }
            }

            public void onFailed(@Nullable String failStr) {
                int errorCode = -9999;
                String string = failStr;
                if (string == null) {
                    string = "\u83b7\u53d6 WebRTC \u914d\u7f6e\u5931\u8d25";
                }
                String errorMsg = string;
                CallSDK.access$postToMain(CallSDK.INSTANCE, (Function0)new Function0<Unit>(this, errorCode, errorMsg){
                    final /* synthetic */ makeCall.1 this$0;
                    final /* synthetic */ int $errorCode;
                    final /* synthetic */ String $errorMsg;

                    public final void invoke() {
                        this.this$0.$listener.onCallFailed(null, this.$errorCode, this.$errorMsg);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$errorCode = n;
                        this.$errorMsg = string;
                        super(0);
                    }
                });
            }
            {
                this.$phoneNumber = $captured_local_variable$0;
                this.$userDataStr = $captured_local_variable$1;
                this.$context = $captured_local_variable$2;
                this.$listener = $captured_local_variable$3;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final SipParams parseSipParamsFromWebRtcInfo(String responseStr, String phoneNumber, String userData) {
        var4_4 = responseStr;
        var5_6 = false;
        var6_8 = false;
        if (var4_4 == null || var4_4.length() == 0) {
            return null;
        }
        try {
            jsonObject = new JSONObject(responseStr);
            dataStr = null;
            if (jsonObject.optBoolean("success", false) || jsonObject.optBoolean("Succeed", false)) {
                v0 = dataStr = jsonObject.optString("data", "");
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"dataStr");
                var6_9 = v0;
                var7_11 = false;
                if (var6_9.length() == 0 && jsonObject.has("registerUrl")) {
                    dataStr = responseStr;
                }
            } else if (jsonObject.has("registerUrl") || jsonObject.has("sip")) {
                dataStr = responseStr;
            }
            var6_10 = dataStr;
            var7_11 = false;
            var8_13 = false;
            if (var6_10 == null || var6_10.length() == 0) {
                Loger.wTag("CallSDK", new Object[]{"No valid data in WebRTC info response"});
                return null;
            }
            dataObject = new JSONObject(dataStr);
            sip = dataObject.optString("sip");
            ctPassword = dataObject.optString("ctPassword");
            if (!dataObject.has("extranalUrl")) ** GOTO lbl-1000
            v1 = dataObject.optString("extranalUrl");
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"dataObject.optString(\"extranalUrl\")");
            var10_15 = v1;
            var11_16 = false;
            if (!(var10_15.length() == 0)) {
                v2 = dataObject.optString("extranalUrl");
            } else lbl-1000:
            // 2 sources

            {
                v2 = dataObject.optString("registerUrl");
            }
            v3 = extranalUrl = v2;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"extranalUrl");
            var10_15 = v3;
            var11_16 = false;
            if (var10_15.length() == 0) {
                Loger.wTag("CallSDK", new Object[]{"extranalUrl is empty"});
                return null;
            }
            addrParts = StringsKt.split$default((CharSequence)extranalUrl, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            if (addrParts.size() < 2) {
                Loger.wTag("CallSDK", new Object[]{"Invalid extranalUrl format: " + extranalUrl});
                return null;
            }
            addr = (String)addrParts.get(0);
            v4 = StringsKt.toIntOrNull((String)((String)addrParts.get(1)));
            if (v4 == null) {
                var13_19 = this;
                var14_21 = false;
                var15_23 = false;
                $this$run = var13_19;
                $i$a$-run-CallSDK$parseSipParamsFromWebRtcInfo$port$1 = false;
                Loger.wTag("CallSDK", new Object[]{"Invalid port: " + (String)addrParts.get(1)});
                return null;
            }
            port = v4;
            var13_20 = new SipParams();
            var14_22 = false;
            var15_24 = false;
            $this$apply = var13_20;
            $i$a$-apply-CallSDK$parseSipParamsFromWebRtcInfo$1 = false;
            $this$apply.setPhoneNum(phoneNumber);
            $this$apply.setAddr(addr);
            $this$apply.setPort(port);
            $this$apply.setSipScret(ctPassword);
            $this$apply.setSipName(sip);
            $this$apply.setUserData(userData);
            return var13_20;
        }
        catch (Exception e) {
            Loger.eTag("CallSDK", new Object[]{"Parse SIP params error: " + e.getMessage()});
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    public static final int hangupCall() {
        INSTANCE.checkInitialized();
        return CallManager.INSTANCE.hangupCall$callsdk_release(CallSDK.getCurrentCallId(), 0);
    }

    @JvmStatic
    public static final boolean getMuteStatus() {
        INSTANCE.checkInitialized();
        return CallManager.INSTANCE.getMuteStatus$callsdk_release();
    }

    @JvmStatic
    private static final int sendDTMF(String callId, char dtmf) {
        INSTANCE.checkInitialized();
        return CallManager.INSTANCE.sendDTMF$callsdk_release(callId, dtmf);
    }

    @JvmStatic
    private static final String getCurrentCall() {
        INSTANCE.checkInitialized();
        return CallManager.INSTANCE.getCurrentCall$callsdk_release();
    }

    private CallSDK() {
    }

    static {
        CallSDK callSDK;
        INSTANCE = callSDK = new CallSDK();
        mainHandler = new Handler(Looper.getMainLooper());
    }

    public static final /* synthetic */ void access$postToMain(CallSDK $this, Function0 block) {
        $this.postToMain((Function0<Unit>)block);
    }

    public static final /* synthetic */ InitListener access$getInitListener$p(CallSDK $this) {
        CallSDK callSDK = $this;
        return initListener;
    }

    public static final /* synthetic */ void access$setInitListener$p(CallSDK $this, InitListener initListener) {
        CallSDK callSDK = $this;
        CallSDK.initListener = initListener;
    }

    public static final /* synthetic */ SipParams access$parseSipParamsFromWebRtcInfo(CallSDK $this, String responseStr, String phoneNumber, String userData) {
        return $this.parseSipParamsFromWebRtcInfo(responseStr, phoneNumber, userData);
    }
}

