//
//  UIConstants.swift
//  JJPhoneDemo
//
//  统一管理常用间距、尺寸、动画时长和主题颜色，避免散落的魔法数字
//

import UIKit

enum UIConstants {
    
    enum Layout {
        static let horizontalPadding: CGFloat = 20
        static let verticalPadding: CGFloat = 20
        static let largeTopOffset: CGFloat = 100
        static let buttonHeight: CGFloat = 44
        static let activeCallNameTopOffset: CGFloat = 40
        static let activeCallStatusSpacing: CGFloat = 15
        static let activeCallBottomButtonOffset: CGFloat = 40
        static let activeCallMiddleButtonOffset: CGFloat = 30
        static let activeCallSideButtonOffset: CGFloat = 100
    }
    
    enum Timing {
        static let short: TimeInterval = 0.3
        static let medium: TimeInterval = 0.5
        static let long: TimeInterval = 2.5
        static let callEnsureAudioDelay: TimeInterval = 0.1
        static let callRingingEnsureDelay: TimeInterval = 3.0
        static let callRingingEnsureExtraDelay: TimeInterval = 5.0
    }
    
    enum Color {
        static let activeCallBackground = UIColor(hexString: "#1C1C1E") ?? .black
        static let activeCallButtonBackground = UIColor(hexString: "#2C2C2E") ?? .systemGray
        
        static var dialBackground: UIColor {
            if #available(iOS 13.0, *) {
                return UIColor(hexString: "#E5E5E5") ?? .systemGray5
            } else {
                return UIColor(hexString: "#E5E5E5") ?? UIColor(white: 0.9, alpha: 1.0)
            }
        }
        
        static var dialButtonBackground: UIColor {
            if #available(iOS 13.0, *) {
                return UIColor(hexString: "#D2D1D9") ?? .systemGray4
            } else {
                return UIColor(hexString: "#D2D1D9") ?? UIColor(white: 0.82, alpha: 1.0)
            }
        }
    }
}


