//
//  ErrorMessageProvider.swift
//  JJPhoneDemo
//
//  将底层错误码转换为用户可读的文案，统一错误提示风格
//

import Foundation

enum ErrorMessageProvider {
    
    /// 登录相关错误的用户可见文案
    static func loginErrorMessage(code: Int, underlyingMessage: String?) -> String {
        if let msg = underlyingMessage, !msg.isEmpty {
            return msg
        }
        // 优先使用 VoIPManager 提供的错误描述
        let description = VoIPManager.errorDescription(forCode: code)
        if !description.isEmpty {
            return description
        }
        // 兜底提示
        return "登录失败（错误码：\(code)）"
    }
    
    /// 呼叫失败时的用户可见文案
    static func callErrorMessage(code: Int?, underlyingMessage: String?) -> String {
        if let msg = underlyingMessage, !msg.isEmpty {
            return msg
        }
        if let code = code {
            let description = VoIPManager.errorDescription(forCode: Int(Int32(code)))
            if !description.isEmpty {
                return description
            }
            return "呼叫失败（错误码：\(code)）"
        }
        return "呼叫失败，请检查号码或网络连接"
    }
}


