/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.service.impl;

import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import cn.hutool.db.Page;
import cn.hutool.db.PageResult;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.ds.DataSourceWrapper;
import cn.hutool.setting.GroupedMap;
import cn.hutool.setting.Setting;
import com.fxiaoke.erpdss.dbproxy.config.DynamicDataSource;
import com.fxiaoke.erpdss.dbproxy.config.SettingManager;
import com.fxiaoke.erpdss.dbproxy.model.DataSourceInfo;
import com.fxiaoke.erpdss.dbproxy.model.result.Result;
import com.fxiaoke.erpdss.dbproxy.service.DataSourceService;
import com.fxiaoke.erpdss.dbproxy.utils.sql.SqlWrapperPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSourceServiceImpl
implements DataSourceService {
    private static final Logger log = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    @Autowired
    private DynamicDataSource dataSource;
    @Autowired
    private SettingManager settingManager;

    public Result<List<DataSourceInfo>> getDataSourceInfos(boolean testDb) {
        Collection values = DynamicDataSource.getDsInfoMap().values();
        if (testDb) {
            for (DataSourceInfo dataSourceInfo : values) {
                try {
                    Db db = this.dataSource.getDb(dataSourceInfo.getName());
                    String testSql = SqlWrapperPool.get((String)dataSourceInfo.getDbType()).testSql();
                    db.query(testSql, new Object[0]);
                    dataSourceInfo.setHealthy(true);
                }
                catch (Exception e) {
                    log.info("test sql exception", (Throwable)e);
                    dataSourceInfo.setHealthy(false);
                }
            }
        }
        return Result.newSuccess(new ArrayList(values));
    }

    public Result<Void> createOrUpdateDataSource(String group, Map<String, String> properties) {
        Setting dbSetting = this.settingManager.getDbSetting();
        GroupedMap groupedMap = dbSetting.getGroupedMap();
        groupedMap.remove((Object)group);
        groupedMap.putAll(group, properties);
        DataSourceWrapper newDs = (DataSourceWrapper)DSFactory.get((String)group);
        this.dataSource.addOrUpdateDataSource(group, newDs, dbSetting.getSetting(group));
        dbSetting.store();
        return Result.newSuccess();
    }

    public Result<Void> removeDataSource(String group) {
        this.dataSource.removeDataSources(group);
        Setting dbSetting = this.settingManager.getDbSetting();
        GroupedMap groupedMap = dbSetting.getGroupedMap();
        groupedMap.remove((Object)group);
        dbSetting.store();
        return Result.newSuccess();
    }

    public Result<Boolean> checkRecordTable() {
        try {
            PageResult syncObjRecord = Db.use((DataSource)this.dataSource).page(Entity.create((String)"sync_obj_record"), Page.of((int)0, (int)1));
            return Result.newSuccess((Object)true);
        }
        catch (Throwable e) {
            log.info("check table exception", e);
            return Result.newError((Throwable)e);
        }
    }
}

