/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.config;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.JarClassLoader;
import cn.hutool.core.lang.Singleton;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Db;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.ds.DataSourceWrapper;
import cn.hutool.setting.Setting;
import com.alibaba.druid.DbType;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.fxiaoke.erpdss.dbproxy.constant.ResultEnum;
import com.fxiaoke.erpdss.dbproxy.exception.CommonException;
import com.fxiaoke.erpdss.dbproxy.model.DataSourceInfo;
import com.fxiaoke.erpdss.dbproxy.utils.DsHolder;
import com.fxiaoke.erpdss.dbproxy.utils.sql.SqlServer2008Dialect;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSource.class);
    private final ConcurrentHashMap<Object, Object> targetDataSources = new ConcurrentHashMap();
    private static final Map<String, DataSourceInfo> dsInfoMap = Collections.synchronizedMap(new LinkedHashMap());

    public DynamicDataSource() {
        this.setTargetDataSources((Map)this.targetDataSources);
    }

    protected String determineCurrentLookupKey() {
        return DsHolder.get();
    }

    public void addOrUpdateDataSource(String dataSourceKey, DataSourceWrapper dataSource, Setting setting) {
        try {
            String driverName;
            DruidDataSource raw = (DruidDataSource)dataSource.getRaw();
            raw.setName(dataSourceKey);
            raw.setBreakAfterAcquireFailure(setting.getBool((Object)"breakAfterAcquireFailure", Boolean.valueOf(true)).booleanValue());
            raw.setConnectionErrorRetryAttempts(setting.getInt((Object)"connectionErrorRetryAttempts", Integer.valueOf(100)).intValue());
            StatFilter statFilter = new StatFilter();
            statFilter.setLogSlowSql(true);
            statFilter.setSlowSqlMillis(10000L);
            statFilter.setMergeSql(true);
            raw.setProxyFilters(Collections.singletonList(statFilter));
            String driverJarPath = setting.get((Object)"driverJarPath");
            if (StrUtil.isNotBlank((CharSequence)driverJarPath)) {
                JarClassLoader jarClassLoader = ClassLoaderUtil.getJarClassLoader((File)FileUtil.file((String)driverJarPath));
                raw.setDriverClassLoader((ClassLoader)jarClassLoader);
                log.info("driver class will load by {}", (Object)driverJarPath);
            }
            if ("oracle.jdbc.OracleDriver".equalsIgnoreCase(driverName = raw.getDriverClassName()) || "oracle.jdbc.driver.OracleDriver".equalsIgnoreCase(driverName)) {
                raw.addConnectionProperty("oracle.jdbc.J2EE13Compliant", "true");
            }
            raw.init();
            String dbType = raw.getDbType();
            if (StringUtils.isEmpty((CharSequence)dbType)) {
                if (setting.get((Object)"url").startsWith("jdbc:ucanaccess:")) {
                    dbType = "access";
                }
                if (setting.get((Object)"url").startsWith("jdbc:bigquery:")) {
                    dbType = "bigquery";
                }
            }
            DataSourceInfo dataSourceInfo = DataSourceInfo.builder().name(dataSourceKey).dbType(dbType).build();
            if (DbType.sqlserver.name().equals(dbType)) {
                dataSourceInfo.setSqlserver2008(setting.getBool((Object)"isSqlServer2008", Boolean.valueOf(false)).booleanValue());
            }
            this.targetDataSources.put(dataSourceKey, dataSource);
            dsInfoMap.put(dataSourceKey, dataSourceInfo);
            super.setTargetDataSources((Map)this.targetDataSources);
            log.info("addOrUpdateDataSource success,{},{}", (Object)dataSourceKey, (Object)dataSourceInfo);
        }
        catch (SQLException e) {
            log.error("init datasource error", (Throwable)e);
            throw new CommonException(String.format("\u6570\u636e\u6e90\u521d\u59cb\u5316\u5931\u8d25,%s,%s", dataSourceKey, ExceptionUtil.getRootCauseMessage((Throwable)e))).setErrorCode(ResultEnum.DATASOURCE_INIT_FAILED.getErrorCode());
        }
        this.afterPropertiesSet();
    }

    public void removeDataSources(String dataSourceKey) {
        this.targetDataSources.remove(dataSourceKey);
        dsInfoMap.remove(dataSourceKey);
        super.setTargetDataSources((Map)this.targetDataSources);
        this.afterPropertiesSet();
    }

    public static List<String> getDataSourceKeys() {
        ArrayList<String> keys = new ArrayList<String>(dsInfoMap.keySet());
        return keys;
    }

    public static Map<String, DataSourceInfo> getDsInfoMap() {
        return MapUtil.unmodifiable((Map)dsInfoMap);
    }

    public static String getCurrentDbType() {
        String s = DsHolder.get();
        return ((DataSourceInfo)dsInfoMap.get(s)).getDbType();
    }

    public static DataSourceInfo getCurrentDsInfo() {
        String s = DsHolder.get();
        return (DataSourceInfo)dsInfoMap.get(s);
    }

    public Db getCurrentDb() {
        DataSource dataSource = this.determineTargetDataSource();
        Db db = DynamicDataSource.getCurrentDsInfo().isSqlserver2008() ? Db.use((DataSource)dataSource, (Dialect)((Dialect)Singleton.get(SqlServer2008Dialect.class, (Object[])new Object[0]))) : Db.use((DataSource)dataSource);
        return db;
    }

    public Db getDb(String groupName) {
        DsHolder.setThreadKey((String)groupName);
        return this.getCurrentDb();
    }
}

