/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.utils;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.fxiaoke.erpdss.dbproxy.exception.CommonException;
import com.fxiaoke.erpdss.dbproxy.model.result.Result;
import com.fxiaoke.erpdss.dbproxy.utils.ThreadUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtil {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtil.class);
    private static ThreadGroup threadGroup = new ThreadGroup("db-background-group");
    private static AtomicInteger count = new AtomicInteger(1);
    private static ExecutorService poolExecutor = TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(2, 9, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(60), (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */, new ThreadPoolExecutor.CallerRunsPolicy()));

    public static Result<String> submit(Runnable runable, Result<String> rs) {
        Future<Result<String>> submit = poolExecutor.submit(runable, rs);
        try {
            Result<String> result = submit.get();
            return result;
        }
        catch (InterruptedException e) {
            log.error("thread executor InterruptedException error", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("thread executor ExecutionException error", (Throwable)e);
        }
        return null;
    }

    public static void submit(Runnable runable) {
        Future<?> submit = poolExecutor.submit(runable);
        try {
            Object o = submit.get();
            log.info("rs\uff1a{}", o);
        }
        catch (InterruptedException e) {
            log.error("thread executor InterruptedException error", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("thread executor ExecutionException error", (Throwable)e);
        }
    }

    public static void submitBatch(List<Runnable> runables) {
        ArrayList futures = new ArrayList();
        for (Runnable runnable : runables) {
            futures.add(poolExecutor.submit(runnable));
        }
        for (Future future : futures) {
            try {
                Object v = future.get();
            }
            catch (InterruptedException e) {
                log.error("thread executor InterruptedException error", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error("thread executor ExecutionException error", (Throwable)e);
            }
        }
    }

    public static void executorBatch(List<ProxyInterFace> prxys) {
        CountDownLatch countDownLatch = new CountDownLatch(prxys.size());
        for (ProxyInterFace prxy : prxys) {
            poolExecutor.execute(() -> {
                try {
                    prxy.run();
                }
                catch (CommonException ec) {
                    throw ec;
                }
                catch (Exception e) {
                    log.error("\u7ebf\u7a0b\u6267\u884c\u5f02\u5e38:{}", (Throwable)e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            log.error("\u7ebf\u7a0b\u6267\u884cwait\u5f02\u5e38:", (Throwable)e);
        }
        catch (IllegalMonitorStateException e2) {
            log.warn("current thread\uff1a{}", (Object)Thread.currentThread().getName(), (Object)e2);
        }
    }

    public static void execute(Runnable runable) {
        poolExecutor.execute(runable);
    }

    static /* synthetic */ ThreadGroup access$000() {
        return threadGroup;
    }

    static /* synthetic */ AtomicInteger access$100() {
        return count;
    }
}

