/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.service.impl;

import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import cn.hutool.db.Page;
import cn.hutool.db.PageResult;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.ds.DataSourceWrapper;
import cn.hutool.setting.GroupedMap;
import cn.hutool.setting.Setting;
import com.fxiaoke.erpdss.dbproxy.config.DynamicDataSource;
import com.fxiaoke.erpdss.dbproxy.config.SettingManager;
import com.fxiaoke.erpdss.dbproxy.model.DataSourceInfo;
import com.fxiaoke.erpdss.dbproxy.model.result.Result;
import com.fxiaoke.erpdss.dbproxy.service.DataSourceService;
import com.fxiaoke.erpdss.dbproxy.utils.sql.SqlWrapperPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSourceServiceImpl
implements DataSourceService {
    private static final Logger log = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    @Autowired
    private DynamicDataSource dataSource;
    @Autowired
    private SettingManager settingManager;

    public Result<List<DataSourceInfo>> getDataSourceInfos(boolean testDb) {
        Collection values = DynamicDataSource.getDsInfoMap().values();
        if (testDb) {
            for (DataSourceInfo dataSourceInfo : values) {
                try {
                    Db db = this.dataSource.getDb(dataSourceInfo.getName());
                    String testSql = SqlWrapperPool.get((String)dataSourceInfo.getDbType()).testSql();
                    db.query(testSql, new Object[0]);
                    dataSourceInfo.setHealthy(true);
                }
                catch (Exception e) {
                    log.info("test sql exception", (Throwable)e);
                    dataSourceInfo.setHealthy(false);
                }
            }
        }
        return Result.newSuccess(new ArrayList(values));
    }

    public Result<Void> createOrUpdateDataSource(String group, Map<String, String> properties) {
        Setting dbSetting = this.settingManager.getDbSetting();
        GroupedMap groupedMap = dbSetting.getGroupedMap();
        groupedMap.remove((Object)group);
        groupedMap.putAll(group, properties);
        DataSourceWrapper newDs = (DataSourceWrapper)DSFactory.get((String)group);
        this.dataSource.addOrUpdateDataSource(group, newDs, dbSetting.getSetting(group));
        dbSetting.store();
        return Result.newSuccess();
    }

    public Result<Void> removeDataSource(String group) {
        this.dataSource.removeDataSources(group);
        Setting dbSetting = this.settingManager.getDbSetting();
        GroupedMap groupedMap = dbSetting.getGroupedMap();
        groupedMap.remove((Object)group);
        dbSetting.store();
        return Result.newSuccess();
    }

    public Result<Boolean> checkRecordTable() {
        try {
            PageResult syncObjRecord = Db.use((DataSource)this.dataSource).page(Entity.create((String)"sync_obj_record"), Page.of((int)0, (int)1));
            return Result.newSuccess((Object)true);
        }
        catch (Throwable e) {
            log.info("check table exception", e);
            return Result.newError((Throwable)e);
        }
    }

    @Nonnull
    private static String getCreateTableSql(String driver) {
        String createTableSql;
        switch (driver) {
            case "org.postgresql.Driver": {
                createTableSql = "CREATE TABLE sync_obj_record (\nid int8 NOT NULL,\nobj_name varchar NOT NULL,\nmd_str varchar NOT NULL,\ndata_id varchar NOT NULL,\ndata_body text NOT NULL,\n\"version\" int NOT NULL,\ncreate_time int8 NOT NULL,\nupdate_time int8 NOT NULL,\nCONSTRAINT sync_obj_record_pk PRIMARY KEY (id)\n);\nCREATE UNIQUE INDEX sync_obj_record_obj_name_idx ON sync_obj_record (obj_name,data_id);\n";
                break;
            }
            case "com.microsoft.sqlserver.jdbc.SQLServerDriver": {
                createTableSql = "CREATE TABLE [dbo].[sync_obj_record] ( [id] bigint NOT NULL, [obj_name] varchar(100) COLLATE Chinese_PRC_CI_AS NOT NULL, [md_str] varchar(32) COLLATE Chinese_PRC_CI_AS NOT NULL, [data_id] varchar(100) COLLATE Chinese_PRC_CI_AS NOT NULL, [data_body] text COLLATE Chinese_PRC_CI_AS NOT NULL, [version] int NOT NULL, [create_time] bigint NOT NULL, [update_time] bigint NOT NULL, CONSTRAINT [PK__sync_obj__3213E83F46CC8028] PRIMARY KEY CLUSTERED ([id])\nWITH\n(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON\n)\nON [PRIMARY] )\nON [PRIMARY] TEXTIMAGE_ON [PRIMARY];\n\nALTER TABLE [dbo].[sync_obj_record]\n\nSET (LOCK_ESCALATION = TABLE);\n\nCREATE UNIQUE NONCLUSTERED INDEX [sync_obj_record_u1]\nON [dbo].[sync_obj_record] ( [obj_name] ASC, [data_id] ASC );";
                break;
            }
            case "oracle.jdbc.driver.OracleDriver": 
            case "oracle.jdbc.OracleDriver": {
                createTableSql = "CREATE TABLE sync_obj_record (\n    id NUMBER(19) NOT NULL,\n    obj_name VARCHAR2(255) NOT NULL,\n    md_str VARCHAR2(255) NOT NULL,\n    data_id VARCHAR2(255) NOT NULL,\n    data_body CLOB NOT NULL,\n    version NUMBER(19) NOT NULL,\n    create_time NUMBER(19) NOT NULL,\n    update_time NUMBER(19) NOT NULL,\n    CONSTRAINT sync_obj_record_pk PRIMARY KEY (id)\n);\n\nCREATE UNIQUE INDEX sync_obj_record_obj_name_idx ON sync_obj_record (obj_name, data_id);";
                break;
            }
            default: {
                createTableSql = "CREATE TABLE sync_obj_record ( id INT NOT NULL,\nobj_name VARCHAR(255) NOT NULL,\nmd_str VARCHAR(255) NOT NULL,\ndata_id VARCHAR(255) NOT NULL,\ndata_body TEXT NOT NULL,\nversion INT NOT NULL,\ncreate_time BIGINT NOT NULL,\nupdate_time BIGINT NOT NULL,\nPRIMARY KEY (id) );\n\nCREATE UNIQUE INDEX sync_obj_record_obj_name_idx ON\nsync_obj_record (obj_name,\ndata_id);";
            }
        }
        return createTableSql;
    }
}

