/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.service.impl;

import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Db;
import cn.hutool.db.Page;
import cn.hutool.db.handler.HandleHelper;
import cn.hutool.db.handler.RsHandler;
import com.fxiaoke.erpdss.dbproxy.config.DynamicDataSource;
import com.fxiaoke.erpdss.dbproxy.dao.SyncObjRecordDao;
import com.fxiaoke.erpdss.dbproxy.entity.SyncObjRecord;
import com.fxiaoke.erpdss.dbproxy.exception.CommonException;
import com.fxiaoke.erpdss.dbproxy.model.DssDataDto;
import com.fxiaoke.erpdss.dbproxy.model.arg.QueryBySqlArg;
import com.fxiaoke.erpdss.dbproxy.model.arg.QueryByTimeFilterArg;
import com.fxiaoke.erpdss.dbproxy.model.arg.QueryFromCacheArg;
import com.fxiaoke.erpdss.dbproxy.model.arg.QueryPageArg;
import com.fxiaoke.erpdss.dbproxy.model.arg.SaveSqlArg;
import com.fxiaoke.erpdss.dbproxy.model.result.InsertDataResult;
import com.fxiaoke.erpdss.dbproxy.model.result.UpdateDataResult;
import com.fxiaoke.erpdss.dbproxy.service.AdaptProxyService;
import com.fxiaoke.erpdss.dbproxy.utils.JacksonUtil;
import com.fxiaoke.erpdss.dbproxy.utils.MD5Util;
import com.fxiaoke.erpdss.dbproxy.utils.SnowFlakeUtil;
import com.fxiaoke.erpdss.dbproxy.utils.ThreadUtil;
import com.fxiaoke.erpdss.dbproxy.utils.sql.SqlWrapperPool;
import com.google.common.base.Splitter;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AdaptProxyServiceImpl
implements AdaptProxyService {
    private static final Logger log = LoggerFactory.getLogger(AdaptProxyServiceImpl.class);
    private final Map<String, Boolean> objCacheStatus = new ConcurrentHashMap();
    @Autowired
    private SyncObjRecordDao syncObjRecordDao;
    @Autowired
    private DynamicDataSource dataSource;

    @Transactional(rollbackFor={Exception.class})
    public InsertDataResult insertData(SaveSqlArg requestArg) {
        String masterSql = requestArg.getAdaptSqlParams().getMasterSql();
        String masterIdSql = requestArg.getAdaptSqlParams().getMasterIdQuerySql();
        Db db = this.dataSource.getCurrentDb();
        String masterId = AdaptProxyServiceImpl.executeInsert((Db)db, (String)masterIdSql, (String)masterSql);
        InsertDataResult result = new InsertDataResult().setMasterDataId(masterId);
        Map detailDataSql = requestArg.getAdaptSqlParams().getDetailSqlList();
        if (!CollectionUtils.isEmpty((Map)detailDataSql)) {
            LinkedHashMap detailIds = new LinkedHashMap();
            result.setDetailDataIds(detailIds);
            for (Map.Entry entry : detailDataSql.entrySet()) {
                ArrayList<String> ids = new ArrayList<String>();
                List sqlList = (List)entry.getValue();
                for (int i = 0; i < sqlList.size(); ++i) {
                    String detailIdQuerySql = "";
                    if (requestArg.getAdaptSqlParams().getDetailIdQuerySql() != null && requestArg.getAdaptSqlParams().getDetailIdQuerySql().containsKey(entry.getKey())) {
                        detailIdQuerySql = (String)((List)requestArg.getAdaptSqlParams().getDetailIdQuerySql().get(entry.getKey())).get(i);
                    }
                    String detailId = AdaptProxyServiceImpl.executeInsert((Db)db, (String)this.dealdetailSqlWithMasetrId((String)sqlList.get(i), masterId), (String)this.dealdetailSqlWithMasetrId(detailIdQuerySql, masterId));
                    ids.add(detailId);
                }
                detailIds.put(entry.getKey(), ids);
            }
        }
        return result;
    }

    private static String executeInsert(Db db, String insertSql, String selectIdSql) {
        String masterId;
        if (StrUtil.isBlank((CharSequence)insertSql)) {
            Long key = db.executeForGeneratedKey(selectIdSql, new Object[0]);
            if (key == null) {
                throw CommonException.error((String)"\u6570\u636e\u63d2\u5165\u540e\u53cd\u67e5Id\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u4ee5\u53ca\u5bf9\u5e94\u7684\u8868\u662f\u5426\u652f\u6301\u81ea\u589e\u957f\u7684\u4e3b\u952e\u5b57\u6bb5\u914d\u7f6e");
            }
            masterId = String.valueOf(key);
        } else {
            int execute = db.execute(selectIdSql, new Object[0]);
            if (execute > 0) {
                masterId = db.queryString(insertSql, new Object[0]);
                if (masterId == null) {
                    throw CommonException.error((String)String.format("\u6570\u636e\u63d2\u5165\u540e\u53cd\u67e5Id\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u914d\u7f6e,\u5f02\u5e38\u67e5\u8be2sql:%s", insertSql));
                }
            } else {
                log.info("executeWithConvertedParameters insertSql:{},selectIdSql:{}", (Object)selectIdSql, (Object)insertSql);
                throw CommonException.error((String)String.format("\u6570\u636e\u63d2\u5165\u5f02\u5e38,\u5f02\u5e38sql:%s", selectIdSql));
            }
        }
        return masterId;
    }

    private static void executeUpdate(Db db, String updateSql) {
        int execute = db.execute(updateSql, new Object[0]);
        if (execute <= 0) {
            log.warn("executeWithConvertedParameters update not effect,update rows is 0, updateSql:{}", (Object)updateSql);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public UpdateDataResult updateData(SaveSqlArg requestArg) {
        UpdateDataResult result = new UpdateDataResult();
        String masterSql = requestArg.getAdaptSqlParams().getMasterSql();
        Db db = this.dataSource.getCurrentDb();
        AdaptProxyServiceImpl.executeUpdate((Db)db, (String)masterSql);
        Map detailDataSql = requestArg.getAdaptSqlParams().getDetailSqlList();
        if (!CollectionUtils.isEmpty((Map)detailDataSql)) {
            LinkedHashMap detailIds = new LinkedHashMap();
            result.setDetailDataIds(detailIds);
            for (Map.Entry entry : detailDataSql.entrySet()) {
                ArrayList<String> ids = new ArrayList<String>();
                List sqlList = (List)entry.getValue();
                for (int i = 0; i < sqlList.size(); ++i) {
                    String detailSql = (String)sqlList.get(i);
                    if (detailSql.toLowerCase().trim().startsWith("insert ")) {
                        String detailIdQuerySql = "";
                        if (requestArg.getAdaptSqlParams().getDetailIdQuerySql() != null && requestArg.getAdaptSqlParams().getDetailIdQuerySql().containsKey(entry.getKey())) {
                            detailIdQuerySql = (String)((List)requestArg.getAdaptSqlParams().getDetailIdQuerySql().get(entry.getKey())).get(i);
                        }
                        String detailId = AdaptProxyServiceImpl.executeInsert((Db)db, (String)detailSql, (String)detailIdQuerySql);
                        ids.add(detailId);
                        continue;
                    }
                    AdaptProxyServiceImpl.executeUpdate((Db)db, (String)detailSql);
                }
                detailIds.put(entry.getKey(), ids);
            }
        }
        return result;
    }

    private String dealdetailSqlWithMasetrId(String detailSql, String masterId) {
        log.info("dealdetailSqlWithMasetrId,masterId={},detailSql={}", (Object)masterId, (Object)detailSql);
        if (StringUtils.isEmpty((Object)detailSql)) {
            return detailSql;
        }
        String newDetailSql = detailSql.replaceAll("'#pid'", String.format("'%s'", masterId));
        log.info("dealdetailSqlWithMasetrId,masterId={},newDetailSql={}", (Object)masterId, (Object)newDetailSql);
        return newDetailSql;
    }

    public void saveRecord(String objApiName, String keyField, DssDataDto dssDataDto) {
        try {
            String dataId = String.valueOf(dssDataDto.getMasterFieldVal().get(keyField));
            String jsonData = JacksonUtil.obj2String((Object)dssDataDto);
            String md5 = MD5Util.getMD5((String)jsonData);
            SyncObjRecord syncObjRecord = this.syncObjRecordDao.get(objApiName, dataId);
            if (syncObjRecord != null && md5.equals(syncObjRecord.getMdStr())) {
                return;
            }
            if (syncObjRecord != null) {
                syncObjRecord.setMdStr(md5);
                syncObjRecord.setDataBody(jsonData);
                syncObjRecord.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
                int update = this.syncObjRecordDao.updateData(syncObjRecord);
                if (update == 0) {
                    log.error("\u66f4\u65b0\u5931\u8d25\uff1adata:{},md:{}", (Object)JacksonUtil.obj2String((Object)dssDataDto), (Object)md5);
                }
            } else {
                syncObjRecord = new SyncObjRecord();
                syncObjRecord.setId(Long.valueOf(SnowFlakeUtil.snowflakeId()));
                syncObjRecord.setMdStr(md5);
                syncObjRecord.setObjName(objApiName);
                syncObjRecord.setDataId(dataId);
                syncObjRecord.setDataBody(jsonData);
                syncObjRecord.setCreateTime(Long.valueOf(System.currentTimeMillis()));
                syncObjRecord.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
                syncObjRecord.setVersion(Integer.valueOf(1));
                int i = this.syncObjRecordDao.insertData(syncObjRecord);
                if (i == 0) {
                    log.error("\u65b0\u589e\u5931\u8d25\uff1adata:{},md:{}", (Object)JacksonUtil.obj2String((Object)dssDataDto), (Object)md5);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6570\u636e\u5931\u8d25:", (Throwable)e);
        }
    }

    private List<DssDataDto> queryDataFromCache(QueryByTimeFilterArg requestArg) {
        if (this.objCacheStatus.getOrDefault(requestArg.getObjApiName(), false).booleanValue()) {
            return Collections.emptyList();
        }
        List dssDataDtos = this.listFromCache(QueryFromCacheArg.fromBatchArg((QueryByTimeFilterArg)requestArg));
        if (CollectionUtils.isEmpty((Collection)dssDataDtos)) {
            QueryPageArg queryPageArg = requestArg.deepClonePageArg();
            ThreadUtil.execute(() -> this.queryAndCache(queryPageArg));
        }
        return dssDataDtos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryAndCache(QueryPageArg queryPageArg) {
        String objApiName = queryPageArg.getObjApiName();
        try {
            this.objCacheStatus.put(objApiName, true);
            queryPageArg.setOffset(Integer.valueOf(0));
            queryPageArg.setLimit(Integer.valueOf(1000));
            for (int i = 0; i < 100000; ++i) {
                List temps = this.queryDataDirector(queryPageArg);
                temps.forEach(v -> this.saveRecord(objApiName, queryPageArg.getMasterPrimaryKey(), v));
                queryPageArg.setOffset(Integer.valueOf(queryPageArg.getOffset() + queryPageArg.getLimit()));
                log.info("cacheObjData ,{},{},{}", new Object[]{objApiName, queryPageArg.getLimit(), queryPageArg.getOffset()});
            }
        }
        catch (Exception e) {
            log.error("cacheObjData error", (Throwable)e);
        }
        finally {
            this.objCacheStatus.put(objApiName, false);
        }
    }

    private List<DssDataDto> listFromCache(QueryFromCacheArg requestArg) {
        Integer offset = requestArg.getOffset();
        Integer limit = requestArg.getLimit();
        List syncObjRecords = this.syncObjRecordDao.listByTime(requestArg.getObjApiName(), requestArg.getStartTime(), requestArg.getEndTime(), offset.intValue(), limit.intValue());
        ArrayList<DssDataDto> dssDataDtos = new ArrayList<DssDataDto>();
        for (SyncObjRecord syncObjRecord : syncObjRecords) {
            DssDataDto dssDataDto = (DssDataDto)JacksonUtil.string2Obj((String)syncObjRecord.getDataBody(), DssDataDto.class);
            dssDataDtos.add(dssDataDto);
        }
        return dssDataDtos;
    }

    private List<DssDataDto> queryDataDirector(QueryPageArg requestArg) {
        log.info("queryDataDirector,requestArg={}", (Object)requestArg);
        int limit = (Integer)ObjUtil.defaultIfNull((Object)requestArg.getLimit(), (Object)10000);
        int offset = (Integer)ObjUtil.defaultIfNull((Object)requestArg.getOffset(), (Object)0);
        ArrayList<DssDataDto> resultDatas = new ArrayList<DssDataDto>();
        String[] sqls = requestArg.getAdaptSqlParams().getMasterSql().split(";");
        ArrayList masterDataList = new ArrayList();
        boolean noOffset = requestArg.isNoOffset();
        Db db = this.dataSource.getCurrentDb();
        for (String sql : sqls) {
            List entities;
            if (noOffset) {
                sql = SqlWrapperPool.get().wrapLimit(sql, limit);
                entities = db.query(sql, new Object[0]);
            } else {
                int pageNum = offset / limit;
                entities = (List)db.page((CharSequence)sql, Page.of((int)pageNum, (int)limit), (RsHandler & Serializable)rs -> (ArrayList)HandleHelper.handleRs((ResultSet)rs, new ArrayList()), new Object[0]);
            }
            masterDataList.addAll(entities);
            if ((limit -= entities.size()) <= 0) break;
        }
        if (CollectionUtils.isEmpty(masterDataList)) {
            return resultDatas;
        }
        boolean queryDetailFlag = !CollectionUtils.isEmpty((Map)requestArg.getAdaptSqlParams().getDetailSqlList());
        for (Map masterData : masterDataList) {
            log.info("queryDataDirector,masterData={}", (Object)masterData);
            DssDataDto dssDataDto = new DssDataDto();
            dssDataDto.setObjAPIName(requestArg.getObjApiName());
            dssDataDto.setMasterFieldVal(masterData);
            HashMap details = new HashMap();
            if (queryDetailFlag) {
                for (Map.Entry entry : requestArg.getAdaptSqlParams().getDetailSqlList().entrySet()) {
                    String detailQuerySql = (String)((List)entry.getValue()).get(0);
                    Object masterIdData = masterData.get(requestArg.getMasterPrimaryKey());
                    if (masterIdData == null && org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)requestArg.getMasterPrimaryKey(), (CharSequence)".")) {
                        List items = Splitter.on((String)".").splitToList((CharSequence)requestArg.getMasterPrimaryKey());
                        log.info("queryDataDirector,masterPrimaryKey={},items={}", (Object)requestArg.getMasterPrimaryKey(), (Object)items);
                        if (!CollectionUtils.isEmpty((Collection)items) && items.size() > 1) {
                            masterIdData = masterData.get(items.get(1));
                        }
                    }
                    log.info("queryDataDirector,masterIdData={}", masterIdData);
                    detailQuerySql = this.dealdetailSqlWithMasetrId(detailQuerySql, String.valueOf(masterIdData));
                    List detailEntities = db.query(detailQuerySql, new Object[0]);
                    List detailDatas = detailEntities.stream().map(v -> new LinkedHashMap(v)).collect(Collectors.toList());
                    details.put(entry.getKey(), detailDatas);
                }
            }
            dssDataDto.setDetailFieldVals(details);
            resultDatas.add(dssDataDto);
        }
        return resultDatas;
    }

    public List<DssDataDto> queryMasterBatch(QueryByTimeFilterArg requestArg) {
        if (requestArg.getQueryDataFromCache().booleanValue()) {
            return this.queryDataFromCache(requestArg);
        }
        return this.queryDataDirector((QueryPageArg)requestArg);
    }

    public DssDataDto queryMasterById(QueryBySqlArg requestArg) {
        QueryPageArg queryPageArg = QueryPageArg.fromSqlArg((QueryBySqlArg)requestArg, (int)0, (int)1, (boolean)true);
        List dssDataDtos = this.queryDataDirector(queryPageArg);
        if (CollectionUtils.isEmpty((Collection)dssDataDtos)) {
            throw CommonException.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (dssDataDtos.size() > 1) {
            throw CommonException.error((String)"\u67e5\u5230\u591a\u4e2a\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        return (DssDataDto)dssDataDtos.get(0);
    }
}

