/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.model.result;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.fxiaoke.erpdss.dbproxy.constant.ResultEnum;
import com.fxiaoke.erpdss.dbproxy.exception.CommonException;
import java.io.Serializable;

/*
 * Exception performing whole class analysis ignored.
 */
public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 564031526747534414L;
    private String errCode;
    private String errMsg;
    private T data;

    public Result() {
        this.errCode = ResultEnum.SUCCESS.getErrorCode();
        this.errMsg = ResultEnum.SUCCESS.getErrorMessage();
    }

    public Result(ResultEnum resultCode) {
        this.errCode = resultCode.getErrorCode();
        this.errMsg = resultCode.getErrorMessage();
    }

    public Result(String errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public Result(T data) {
        this.errCode = ResultEnum.SUCCESS.getErrorCode();
        this.errMsg = "success";
        this.data = data;
    }

    public static <R> Result<R> newError(ResultEnum resultCode) {
        return new Result(resultCode);
    }

    public static <R> Result<R> newError(String errMsg) {
        return new Result(ResultEnum.SYSTEM_ERROR.getErrorCode(), errMsg);
    }

    public static <R> Result<R> newError(String errCode, String errMsg) {
        return new Result(errCode, errMsg);
    }

    public static <R> Result<R> newError(Throwable th) {
        CommonException causedBy = (CommonException)ExceptionUtil.getCausedBy((Throwable)th, (Class[])new Class[]{CommonException.class});
        if (causedBy != null) {
            return new Result(causedBy.getErrorCode(), causedBy.getMessage());
        }
        return Result.newError((String)th.getMessage());
    }

    public static <R> Result<R> wrapError(Result<?> errorResult) {
        return Result.newError((String)errorResult.getErrCode(), (String)errorResult.getErrMsg());
    }

    public static <R> Result<R> newSuccess() {
        return new Result();
    }

    public static <R> Result<R> newSuccess(R data) {
        return new Result(data);
    }

    public boolean isSuccess() {
        return ResultEnum.SUCCESS.getErrorCode().equals(this.errCode);
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public T getData() {
        return (T)this.data;
    }

    public Result<T> setErrCode(String errCode) {
        this.errCode = errCode;
        return this;
    }

    public Result<T> setErrMsg(String errMsg) {
        this.errMsg = errMsg;
        return this;
    }

    public Result<T> setData(T data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$errCode = this.getErrCode();
        String other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !this$errCode.equals(other$errCode)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : $errCode.hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(errCode=" + this.getErrCode() + ", errMsg=" + this.getErrMsg() + ", data=" + this.getData() + ")";
    }

    public Result(String errCode, String errMsg, T data) {
        this.errCode = errCode;
        this.errMsg = errMsg;
        this.data = data;
    }
}

