/*
 * Decompiled with CFR 0.152.
 */
package com.fxiaoke.erpdss.dbproxy.controller.api;

import cn.dev33.satoken.annotation.SaIgnore;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.fxiaoke.erpdss.dbproxy.model.DataSourceInfo;
import com.fxiaoke.erpdss.dbproxy.model.ServiceInfo;
import com.fxiaoke.erpdss.dbproxy.model.result.Result;
import com.fxiaoke.erpdss.dbproxy.service.DataSourceService;
import java.io.File;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dbadapt/proxy/api"})
public class ServiceInfoController {
    private static final Logger log = LoggerFactory.getLogger(ServiceInfoController.class);
    @Autowired(required=false)
    private BuildProperties buildProperties;
    @Autowired
    private DataSourceService dataSourceService;

    @RequestMapping(value={"/getServiceInfo"})
    @ResponseBody
    public Result<ServiceInfo> getServiceInfo(@RequestParam(defaultValue="false") boolean testDb) {
        if (this.buildProperties == null) {
            Properties properties = new Properties();
            properties.setProperty("group", "com.fxiaoke.erpdss");
            properties.setProperty("artifact", "db-proxy-server");
            properties.setProperty("version", "2.2");
            properties.setProperty("time", Instant.now().toString());
            properties.setProperty("name", "db-proxy-server");
            this.buildProperties = new BuildProperties(properties);
        }
        DateTime buildTime = DateUtil.date((TemporalAccessor)this.buildProperties.getTime());
        String version = this.buildProperties.getVersion();
        version = version + "." + buildTime.toString("yyyyMMdd");
        ServiceInfo serviceInfo = ServiceInfo.builder().version(version).group(this.buildProperties.getGroup()).artifact(this.buildProperties.getArtifact()).time(buildTime.toString()).dataSourceInfoList((List)this.getDataSourceInfos(testDb).getData()).build();
        return Result.newSuccess((Object)serviceInfo);
    }

    @PostMapping(value={"getDataSourceInfos"})
    public Result<List<DataSourceInfo>> getDataSourceInfos(@RequestParam(defaultValue="false") boolean testDb) {
        return this.dataSourceService.getDataSourceInfos(testDb);
    }

    @RequestMapping(value={"/checkExistRecordTable"})
    @ResponseBody
    public Result<Boolean> checkExistRecordTable() {
        return this.dataSourceService.checkRecordTable();
    }

    @RequestMapping(value={"/test"})
    @ResponseBody
    @SaIgnore
    public String test() {
        return "success";
    }

    @GetMapping(value={"/listLogs"})
    public Result<List<Dict>> listLogs() {
        String workingDir = System.getProperty("user.dir");
        List files = FileUtil.loopFiles((String)(workingDir + "/logs"));
        List collect = files.stream().map(v -> Dict.of((Object[])new Object[]{"pathOri", StrUtil.removePrefix((CharSequence)v.getPath(), (CharSequence)workingDir), "path", URLUtil.encode((String)StrUtil.removePrefix((CharSequence)v.getPath(), (CharSequence)workingDir)), "name", v.getName(), "size", FileUtil.readableFileSize((File)v)})).collect(Collectors.toList());
        return Result.newSuccess(collect);
    }
}

