/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx.impl;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.properties.PropertiesPanel;
import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.jmx.JmxConnectionCustomizer;
import com.sun.tools.visualvm.jmx.impl.JmxApplication;
import com.sun.tools.visualvm.jmx.impl.JmxConnectionSupportImpl;
import com.sun.tools.visualvm.jmx.impl.JmxPropertiesProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class JmxConnectionConfigurator
extends JPanel {
    private static final Icon INFO_ICON = ImageUtilities.loadImageIcon((String)"com/sun/tools/visualvm/jmx/resources/infoIcon.png", (boolean)false);
    private boolean singleCustomizer;
    private JmxConnectionCustomizer selectedCustomizer;
    private PropertiesPanel displayedPanel;
    private List<JmxConnectionCustomizer> customizers = new ArrayList<JmxConnectionCustomizer>();
    private List<PropertiesPanel> customizerPanels = new ArrayList<PropertiesPanel>();
    private SelectionListener selectionListener = new SelectionListener();
    private ValidityListener validityListener = new ValidityListener();
    private String lastSelectedItem;
    private Dimension lastSize;
    private DefaultListModel connectionTypeListModel;
    private JButton okButton;
    private JLabel hintLabel;
    private JLabel connectionTypeLabel;
    private JList connectionTypeList;
    private JScrollPane connectionTypeScroll;
    private JPanel customizerPanel;
    private ScrollableContainer customizerPanelScroll;
    private static JmxConnectionConfigurator INSTANCE;

    static Result getResult() {
        JmxConnectionConfigurator configurator = JmxConnectionConfigurator.instance();
        configurator.warmup();
        DialogDescriptor dd = new DialogDescriptor((Object)configurator, NbBundle.getMessage(JmxConnectionConfigurator.class, (String)"Title_Add_JMX_Connection"), true, new Object[]{configurator.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)configurator.okButton, 0, null, null);
        dd.setAdditionalOptions(new Object[]{configurator.hintLabel});
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        configurator.updateWindowTitle(d);
        d.pack();
        d.setVisible(true);
        Result result = configurator.get(dd.getValue() == configurator.okButton);
        configurator.cleanup();
        return result;
    }

    public static synchronized JmxConnectionConfigurator instance() {
        if (INSTANCE == null) {
            INSTANCE = new JmxConnectionConfigurator();
        }
        return INSTANCE;
    }

    public void warmup() {
        this.customizers.addAll(JmxConnectionSupportImpl.getCustomizers());
        this.singleCustomizer = this.customizers.size() == 1;
        JmxConnectionCustomizer itemToSelect = null;
        for (JmxConnectionCustomizer customizer : this.customizers) {
            this.connectionTypeListModel.addElement(customizer);
            this.customizerPanels.add(customizer.createPanel(null));
            if (!customizer.toString().equals(this.lastSelectedItem)) continue;
            itemToSelect = customizer;
        }
        boolean selectorVisible = this.customizers.size() > 1;
        this.connectionTypeLabel.setVisible(selectorVisible);
        this.connectionTypeScroll.setVisible(selectorVisible);
        this.customizerPanelScroll.setBorder(selectorVisible ? BorderFactory.createEmptyBorder(5, 8, 0, 5) : BorderFactory.createEmptyBorder(15, 5, 0, 5));
        this.connectionTypeList.addListSelectionListener(this.selectionListener);
        if (itemToSelect == null) {
            this.connectionTypeList.setSelectedIndex(0);
        } else {
            this.connectionTypeList.setSelectedValue((Object)itemToSelect, true);
        }
        this.updateOkButton();
        if (this.lastSize != null) {
            this.customizerPanelScroll.setPreferredSize(this.lastSize);
        } else {
            this.initializePreferredSize();
        }
    }

    public Result get(boolean accepted) {
        JmxConnectionCustomizer.Setup setup = null;
        if (accepted && this.selectedCustomizer != null && this.displayedPanel != null) {
            setup = this.selectedCustomizer.getConnectionSetup(this.displayedPanel);
        }
        return new Result(setup, this.selectedCustomizer, this.customizers, this.customizerPanels);
    }

    public void cleanup() {
        Object selectedItem = this.connectionTypeList.getSelectedValue();
        this.lastSelectedItem = selectedItem == null ? null : selectedItem.toString();
        this.connectionTypeList.clearSelection();
        this.connectionTypeList.removeListSelectionListener(this.selectionListener);
        this.lastSize = this.customizerPanelScroll.getSize();
        this.customizers.clear();
        this.customizerPanels.clear();
        this.customizerPanel.removeAll();
        this.connectionTypeListModel.clear();
        this.selectedCustomizer = null;
    }

    public void updateWindowTitle(Window w) {
        if (this.singleCustomizer) {
            return;
        }
        String title = NbBundle.getMessage(JmxConnectionConfigurator.class, (String)"Title_Add_JMX_Connection") + " - " + this.selectedCustomizer.getPropertiesName();
        if (w instanceof Dialog) {
            ((Dialog)w).setTitle(title);
        } else if (w instanceof Frame) {
            ((Frame)w).setTitle(title);
        }
    }

    private void updateSelectedCustomizer() {
        this.selectedCustomizer = (JmxConnectionCustomizer)((Object)this.connectionTypeList.getSelectedValue());
        if (this.displayedPanel != null) {
            this.displayedPanel.removeChangeListener((ChangeListener)this.validityListener);
            this.customizerPanel.removeAll();
        }
        if (this.selectedCustomizer != null) {
            this.displayedPanel = this.customizerPanels.get(this.connectionTypeListModel.indexOf((Object)this.selectedCustomizer));
            this.updateWindowTitle(SwingUtilities.getWindowAncestor(this));
        }
        if (this.displayedPanel != null) {
            this.displayedPanel.addChangeListener((ChangeListener)this.validityListener);
            this.customizerPanel.add((Component)this.displayedPanel, "Center");
            this.customizerPanel.revalidate();
            this.customizerPanel.repaint();
            this.updateOkButton();
        }
    }

    private void updateOkButton() {
        this.okButton.setEnabled(this.displayedPanel != null && this.displayedPanel.settingsValid());
    }

    private void updateHint() {
        String hintText;
        String string = hintText = this.selectedCustomizer == null ? null : this.selectedCustomizer.getPropertiesDescription();
        if (hintText != null && !this.singleCustomizer) {
            this.hintLabel.setIcon(INFO_ICON);
            this.hintLabel.setText(hintText);
        } else {
            this.hintLabel.setIcon(null);
            this.hintLabel.setText("");
        }
    }

    private void initializePreferredSize() {
        Dimension preferredSize = new Dimension();
        for (PropertiesPanel panel : this.customizerPanels) {
            Dimension panelPref = panel.getPreferredSize();
            preferredSize.width = Math.max(preferredSize.width, panelPref.width);
            preferredSize.height = Math.max(preferredSize.height, panelPref.height);
        }
        Insets insets = this.customizerPanelScroll.getInsets();
        preferredSize.width += insets.left + insets.right;
        preferredSize.height += insets.top + insets.bottom;
        if (!this.singleCustomizer) {
            preferredSize.height += 40;
        }
        this.customizerPanelScroll.setPreferredSize(preferredSize);
    }

    private JmxConnectionCustomizer getCustomizer(Point location) {
        int index = this.connectionTypeList.locationToIndex(location);
        if (index == -1) {
            return null;
        }
        if (!this.connectionTypeList.getCellBounds(index, index).contains(location)) {
            return null;
        }
        return (JmxConnectionCustomizer)((Object)this.connectionTypeListModel.getElementAt(index));
    }

    private void initComponents() {
        this.okButton = new JButton(NbBundle.getMessage(JmxConnectionConfigurator.class, (String)"LBL_OK"));
        this.hintLabel = new JLabel(""){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = Math.max(d.height, ((JmxConnectionConfigurator)JmxConnectionConfigurator.this).okButton.getPreferredSize().height);
                return d;
            }
        };
        this.hintLabel.setForeground(UIManager.getColor("Label.disabledForeground"));
        this.setLayout(new BorderLayout());
        this.connectionTypeLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.connectionTypeLabel, (String)NbBundle.getMessage(JmxConnectionConfigurator.class, (String)"LBL_Connection_type"));
        JmxConnectionConfigurator.createBorder(this.connectionTypeLabel, BorderFactory.createEmptyBorder(15, 10, 0, 10));
        this.add((Component)this.connectionTypeLabel, "North");
        this.connectionTypeListModel = new DefaultListModel();
        this.connectionTypeList = new JList(this.connectionTypeListModel){

            public String getToolTipText(MouseEvent evt) {
                JmxConnectionCustomizer cust = JmxConnectionConfigurator.this.getCustomizer(evt.getPoint());
                return cust == null ? null : cust.getPropertiesDescription();
            }
        };
        this.connectionTypeLabel.setLabelFor(this.connectionTypeList);
        this.connectionTypeList.setSelectionModel(new DefaultListSelectionModel(){

            public void removeSelectionInterval(int i1, int i2) {
            }
        });
        this.connectionTypeList.setSelectionMode(0);
        final ListCellRenderer<String> defaultRenderer = this.connectionTypeList.getCellRenderer();
        Component c = defaultRenderer.getListCellRendererComponent(this.connectionTypeList, "X", 0, false, false);
        this.connectionTypeList.setFixedCellHeight(c.getPreferredSize().height + 2);
        this.connectionTypeList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return defaultRenderer.getListCellRendererComponent(list, " " + value + " ", index, isSelected, cellHasFocus);
            }
        });
        this.connectionTypeScroll = new JScrollPane(this.connectionTypeList, 20, 30){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                preferredSize.width = Math.min(preferredSize.width, 300);
                preferredSize.width = Math.max(preferredSize.width, 120);
                return preferredSize;
            }
        };
        JmxConnectionConfigurator.createBorder(this.connectionTypeScroll, BorderFactory.createEmptyBorder(5, 10, 0, 0));
        this.add((Component)this.connectionTypeScroll, "West");
        this.customizerPanel = new JPanel(new BorderLayout());
        this.customizerPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.customizerPanelScroll = new ScrollableContainer((JComponent)this.customizerPanel, 20, 31);
        this.customizerPanelScroll.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 5));
        this.add((Component)this.customizerPanelScroll, "Center");
    }

    private static void createBorder(JComponent component, Border border) {
        Border cBorder = component.getBorder();
        if (cBorder == null) {
            component.setBorder(border);
        } else {
            component.setBorder(BorderFactory.createCompoundBorder(border, cBorder));
        }
    }

    private JmxConnectionConfigurator() {
        this.initComponents();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Result {
        private final JmxConnectionCustomizer.Setup setup;
        private final JmxConnectionCustomizer selectedCustomizer;
        private final List<JmxConnectionCustomizer> customizers = new ArrayList<JmxConnectionCustomizer>();
        private final List<PropertiesPanel> customizerPanels = new ArrayList<PropertiesPanel>();

        public Result(JmxConnectionCustomizer.Setup setup, JmxConnectionCustomizer selectedCustomizer, List<JmxConnectionCustomizer> customizers, List<PropertiesPanel> customizerPanels) {
            this.setup = setup;
            this.selectedCustomizer = selectedCustomizer;
            this.customizers.addAll(customizers);
            this.customizerPanels.addAll(customizerPanels);
        }

        public JmxConnectionCustomizer.Setup getSetup() {
            return this.setup;
        }

        public void accepted(JmxApplication application) {
            for (int i = 0; i < this.customizers.size(); ++i) {
                JmxConnectionCustomizer c = this.customizers.get(i);
                if (c == this.selectedCustomizer) {
                    JmxPropertiesProvider.setCustomizer(application, this.selectedCustomizer);
                    c.propertiesDefined(this.customizerPanels.get(i), application);
                    continue;
                }
                this.customizers.get(i).propertiesCancelled(this.customizerPanels.get(i), (Application)null);
            }
        }

        public void cancelled() {
            for (int i = 0; i < this.customizers.size(); ++i) {
                this.customizers.get(i).propertiesCancelled(this.customizerPanels.get(i), (Application)null);
            }
        }
    }

    private class ValidityListener
    implements ChangeListener {
        private ValidityListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JmxConnectionConfigurator.this.updateOkButton();
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                JmxConnectionConfigurator.this.updateSelectedCustomizer();
                JmxConnectionConfigurator.this.updateHint();
            }
        }
    }
}

