/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.snapshot;

import com.sun.tools.visualvm.application.snapshot.ApplicationSnapshot;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.profiling.snapshot.ProfilerSnapshot;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openide.util.NbBundle;

final class ProfilerSnapshotView
extends DataSourceView {
    private ProfilerSnapshot loadedSnapshot = null;

    public ProfilerSnapshotView(ProfilerSnapshot snapshot) {
        this(snapshot, DataSourceDescriptorFactory.getDescriptor((DataSource)snapshot));
    }

    private ProfilerSnapshotView(ProfilerSnapshot snapshot, DataSourceDescriptor descriptor) {
        super((DataSource)snapshot, descriptor.getName(), descriptor.getIcon(), 0x7FFFFFFE, ProfilerSnapshotView.isClosableView(snapshot));
        this.loadedSnapshot = snapshot;
    }

    protected void removed() {
        this.loadedSnapshot.closeComponent();
        this.loadedSnapshot = null;
    }

    protected DataViewComponent createComponent() {
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport().getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        return dvc;
    }

    private static boolean isClosableView(ProfilerSnapshot snapshot) {
        if (!snapshot.isVisible()) {
            return false;
        }
        DataSource owner = snapshot.getOwner();
        if (owner == null) {
            return false;
        }
        while (owner != null && owner != DataSource.ROOT) {
            if (owner instanceof ApplicationSnapshot) {
                return true;
            }
            if (!owner.isVisible()) {
                return false;
            }
            owner = owner.getOwner();
        }
        return owner == DataSource.ROOT;
    }

    private class MasterViewSupport
    extends JPanel {
        private MasterViewSupport() {
        }

        public DataViewComponent.MasterView getMasterView() {
            JComponent srw = ProfilerSnapshotView.this.loadedSnapshot.getUIComponent();
            return new DataViewComponent.MasterView(NbBundle.getMessage(ProfilerSnapshotView.class, (String)"DESCR_Profiler_Snapshot"), null, srw);
        }
    }
}

