/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.text.Format;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.swing.renderer.BaseDetailsRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;

public class NumberPercentRenderer
extends BaseDetailsRenderer {
    private static final String NUL = Formatters.percentFormat().format(0);
    private static final String NAN = NUL.replace("0", "-");
    private long basis;

    public NumberPercentRenderer() {
        this(null);
    }

    public NumberPercentRenderer(Format format) {
        super(new NumberRenderer(format), NumberPercentRenderer.getPercentString(Float.valueOf(999.9f), 100L), 0);
    }

    public void setBasis(long l) {
        this.basis = l;
    }

    @Override
    public void setValue(Object object, int n) {
        this.setValues(object, NumberPercentRenderer.getPercentString((Number)object, this.basis), n);
    }

    private static String getPercentString(Number number, long l) {
        String string = "(";
        string = l == 0L ? string + NAN : string + (number.longValue() == 0L ? NUL : Formatters.percentFormat().format(number.doubleValue() / (double)l));
        return string + ")";
    }
}

